/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.ast;

import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.ast.FuncArgs;
import li.cil.repack.org.luaj.vm2.ast.FuncBody;
import li.cil.repack.org.luaj.vm2.ast.Name;
import li.cil.repack.org.luaj.vm2.ast.SyntaxElement;
import li.cil.repack.org.luaj.vm2.ast.TableConstructor;
import li.cil.repack.org.luaj.vm2.ast.Visitor;

public abstract class Exp
extends SyntaxElement {
    public abstract void accept(Visitor var1);

    public static Exp constant(LuaValue value) {
        return new Constant(value);
    }

    public static Exp numberconstant(String token) {
        return new Constant(LuaValue.valueOf(token).tonumber());
    }

    public static Exp varargs() {
        return new VarargsExp();
    }

    public static Exp tableconstructor(TableConstructor tc) {
        return tc;
    }

    public static Exp unaryexp(int op, Exp rhs) {
        if (rhs instanceof BinopExp) {
            BinopExp b = (BinopExp)rhs;
            if (Exp.precedence(op) > Exp.precedence(b.op)) {
                return Exp.binaryexp(Exp.unaryexp(op, b.lhs), b.op, b.rhs);
            }
        }
        return new UnopExp(op, rhs);
    }

    public static Exp binaryexp(Exp lhs, int op, Exp rhs) {
        BinopExp b;
        if (lhs instanceof UnopExp) {
            UnopExp u = (UnopExp)lhs;
            if (Exp.precedence(op) > Exp.precedence(u.op)) {
                return Exp.unaryexp(u.op, Exp.binaryexp(u.rhs, op, rhs));
            }
        }
        if (lhs instanceof BinopExp) {
            b = (BinopExp)lhs;
            if (Exp.precedence(op) > Exp.precedence(b.op) || Exp.precedence(op) == Exp.precedence(b.op) && Exp.isrightassoc(op)) {
                return Exp.binaryexp(b.lhs, b.op, Exp.binaryexp(b.rhs, op, rhs));
            }
        }
        if (rhs instanceof BinopExp) {
            b = (BinopExp)rhs;
            if (Exp.precedence(op) > Exp.precedence(b.op) || Exp.precedence(op) == Exp.precedence(b.op) && !Exp.isrightassoc(op)) {
                return Exp.binaryexp(Exp.binaryexp(lhs, op, b.lhs), b.op, b.rhs);
            }
        }
        return new BinopExp(lhs, op, rhs);
    }

    static boolean isrightassoc(int op) {
        switch (op) {
            case 18: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    static int precedence(int op) {
        switch (op) {
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 24: 
            case 25: 
            case 26: 
            case 61: 
            case 62: 
            case 63: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 13: 
            case 14: {
                return 4;
            }
            case 15: 
            case 16: 
            case 17: {
                return 5;
            }
            case 19: 
            case 20: 
            case 21: {
                return 6;
            }
            case 18: {
                return 7;
            }
        }
        throw new IllegalStateException("precedence of bad op " + op);
    }

    public static Exp anonymousfunction(FuncBody funcbody) {
        return new AnonFuncDef(funcbody);
    }

    public static NameExp nameprefix(String name) {
        return new NameExp(name);
    }

    public static ParensExp parensprefix(Exp exp2) {
        return new ParensExp(exp2);
    }

    public static IndexExp indexop(PrimaryExp lhs, Exp exp2) {
        return new IndexExp(lhs, exp2);
    }

    public static FieldExp fieldop(PrimaryExp lhs, String name) {
        return new FieldExp(lhs, name);
    }

    public static FuncCall functionop(PrimaryExp lhs, FuncArgs args) {
        return new FuncCall(lhs, args);
    }

    public static MethodCall methodop(PrimaryExp lhs, String name, FuncArgs args) {
        return new MethodCall(lhs, name, args);
    }

    public boolean isvarexp() {
        return false;
    }

    public boolean isfunccall() {
        return false;
    }

    public boolean isvarargexp() {
        return false;
    }

    public static class AnonFuncDef
    extends Exp {
        public final FuncBody body;

        public AnonFuncDef(FuncBody funcbody) {
            this.body = funcbody;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BinopExp
    extends Exp {
        public final Exp lhs;
        public final Exp rhs;
        public final int op;

        public BinopExp(Exp lhs, int op, Exp rhs) {
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class UnopExp
    extends Exp {
        public final int op;
        public final Exp rhs;

        public UnopExp(int op, Exp rhs) {
            this.op = op;
            this.rhs = rhs;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class VarargsExp
    extends Exp {
        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean isvarargexp() {
            return true;
        }
    }

    public static class Constant
    extends Exp {
        public final LuaValue value;

        public Constant(LuaValue value) {
            this.value = value;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class MethodCall
    extends FuncCall {
        public final String name;

        public MethodCall(PrimaryExp lhs, String name, FuncArgs args) {
            super(lhs, args);
            this.name = new String(name);
        }

        @Override
        public boolean isfunccall() {
            return true;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FuncCall
    extends PrimaryExp {
        public final PrimaryExp lhs;
        public final FuncArgs args;

        public FuncCall(PrimaryExp lhs, FuncArgs args) {
            this.lhs = lhs;
            this.args = args;
        }

        @Override
        public boolean isfunccall() {
            return true;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean isvarargexp() {
            return true;
        }
    }

    public static class IndexExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Exp exp;

        public IndexExp(PrimaryExp lhs, Exp exp2) {
            this.lhs = lhs;
            this.exp = exp2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FieldExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Name name;

        public FieldExp(PrimaryExp lhs, String name) {
            this.lhs = lhs;
            this.name = new Name(name);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ParensExp
    extends PrimaryExp {
        public final Exp exp;

        public ParensExp(Exp exp2) {
            this.exp = exp2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NameExp
    extends VarExp {
        public final Name name;

        public NameExp(String name) {
            this.name = new Name(name);
        }

        @Override
        public void markHasAssignment() {
            this.name.variable.hasassignments = true;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class VarExp
    extends PrimaryExp {
        @Override
        public boolean isvarexp() {
            return true;
        }

        public void markHasAssignment() {
        }
    }

    public static abstract class PrimaryExp
    extends Exp {
        @Override
        public boolean isvarexp() {
            return false;
        }

        @Override
        public boolean isfunccall() {
            return false;
        }
    }
}

