/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.ServerTickCallback;
import com.tamashenning.forgeanalytics.client.ForgeAnalyticsConstants;
import com.tamashenning.forgeanalytics.events.AnalyticsEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ITickable;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class FTBLibEventHandler
implements ITickable {
    public static final FTBLibEventHandler instance = new FTBLibEventHandler();
    public static final List<ServerTickCallback> callbacks = new ArrayList<ServerTickCallback>();
    public static final List<ServerTickCallback> pendingCallbacks = new ArrayList<ServerTickCallback>();

    @SubscribeEvent
    public void onWorldSaved(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && event.getWorld() instanceof WorldServer) {
            try {
                ForgeWorldMP.inst.save();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="forgeanalytics")
    public void onAnalytics(AnalyticsEvent event) {
        ForgeWorld w = ForgeWorld.getFrom(event.side);
        if (w != null) {
            ForgeAnalyticsConstants.CustomProperties.put("FTB_PackMode", w.getMode().getID());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP && ForgeWorldMP.inst != null) {
            boolean firstLogin;
            EntityPlayerMP ep = (EntityPlayerMP)e.player;
            ForgePlayerMP p = ForgeWorldMP.inst.getPlayer(ep);
            boolean bl = firstLogin = p == null;
            if (firstLogin) {
                p = new ForgePlayerMP(ep.func_146103_bH());
                ForgeWorldMP.inst.playerMap.put(p.getProfile().getId(), p);
            } else if (!p.getProfile().getName().equals(ep.func_70005_c_())) {
                p.setProfile(ep.func_146103_bH());
            }
            p.setPlayer(ep);
            p.onLoggedIn(firstLogin);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        ForgePlayerMP p;
        if (e.player instanceof EntityPlayerMP && ForgeWorldMP.inst != null && (p = ForgeWorldMP.inst.getPlayer(e.player)) != null) {
            p.onLoggedOut();
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.getEntity() instanceof EntityPlayerMP && ForgeWorldMP.inst != null) {
            ForgeWorldMP.inst.getPlayer(e.getEntity()).onDeath();
        }
    }

    public void func_73660_a() {
        if (!pendingCallbacks.isEmpty()) {
            callbacks.addAll(pendingCallbacks);
            pendingCallbacks.clear();
        }
        if (!callbacks.isEmpty()) {
            for (int i = callbacks.size() - 1; i >= 0; --i) {
                if (!callbacks.get(i).incAndCheck()) continue;
                callbacks.remove(i);
            }
        }
    }
}

