/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl;

import com.feed_the_beast.ftbl.FTBLibEventHandler;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.FTBLibStats;
import com.feed_the_beast.ftbl.api.FTBLibCapabilities;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.PackModes;
import com.feed_the_beast.ftbl.api.config.ConfigRegistry;
import com.feed_the_beast.ftbl.api.item.ODItems;
import com.feed_the_beast.ftbl.api.notification.ClickActionType;
import com.feed_the_beast.ftbl.cmd.CmdFTB;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.feed_the_beast.ftbl.util.LMMod;
import com.feed_the_beast.ftbl.util.ReloadType;
import com.latmod.lib.OS;
import java.io.File;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ftbl", name="FTBLib", version="2.1.0", dependencies="required-after:Forge@[12.16.0.1987,);after:Baubles;after:JEI;after:Waila;after:MineTweaker3", acceptedMinecraftVersions="[1.9.4]")
public class FTBLibMod {
    public static final Logger logger = LogManager.getLogger((String)"FTBLib");
    @Mod.Instance(value="ftbl")
    public static FTBLibMod inst;
    @SidedProxy(serverSide="com.feed_the_beast.ftbl.FTBLibModCommon", clientSide="com.feed_the_beast.ftbl.client.FTBLibModClient")
    public static FTBLibModCommon proxy;
    public static LMMod mod;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        if (FTBLib.DEV_ENV) {
            logger.info("Loading FTBLib, DevEnv");
        } else {
            logger.info("Loading FTBLib, v2.1.0");
        }
        logger.info("OS: " + (Object)((Object)OS.current) + ", 64bit: " + OS.IS_64_ARCH);
        mod = LMMod.create("ftbl");
        FTBLib.init(e.getModConfigurationDirectory());
        JsonHelper.init();
        FTBLibNetHandler.init();
        ODItems.preInit();
        FTBLibStats.init();
        MinecraftForge.EVENT_BUS.register((Object)FTBLibEventHandler.instance);
        FTBLibCapabilities.init();
        ClickActionType.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        PackModes.reload();
        ConfigRegistry.reload();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CmdFTB(e.getServer().func_71262_S()));
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerAboutToStartEvent e) {
        ConfigRegistry.reload();
        PackModes.reload();
        FTBLib.folderWorld = new File(FMLCommonHandler.instance().getSavesDirectory(), e.getServer().func_71270_I());
        ForgeWorldMP.inst = new ForgeWorldMP();
        try {
            ForgeWorldMP.inst.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FTBLib.registerServerTickable(e.getServer(), FTBLibEventHandler.instance);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent e) {
        FTBLib.reload((ICommandSender)FTBLib.getServer(), ReloadType.SERVER_ONLY, false);
    }

    @Mod.EventHandler
    public void onServerShutDown(FMLServerStoppedEvent e) {
        ForgeWorldMP.inst.onClosed();
        ForgeWorldMP.inst = null;
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> m, Side side) {
        String s = m.get("ftbl");
        return s == null || s.equals("2.1.0");
    }
}

