/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.paint.IPaintable;
import com.feed_the_beast.ftbl.api.paint.IPainterItem;
import com.feed_the_beast.ftbl.api.paint.PaintStorage;
import com.feed_the_beast.ftbl.api.paint.PainterItemStorage;
import com.feed_the_beast.ftbl.api.security.ISecure;
import com.feed_the_beast.ftbl.api.security.ISecureStorage;
import com.feed_the_beast.ftbl.api.security.Security;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class FTBLibCapabilities {
    @CapabilityInject(value=IPaintable.class)
    public static Capability<IPaintable> PAINTABLE_TILE = null;
    @CapabilityInject(value=IPainterItem.class)
    public static Capability<IPainterItem> PAINTER_ITEM = null;
    @CapabilityInject(value=ISecure.class)
    public static Capability<ISecure> SECURE = null;
    private static boolean inited = false;

    public static void init() {
        if (!inited) {
            inited = true;
            CapabilityManager.INSTANCE.register(IPaintable.class, (Capability.IStorage)new Capability.IStorage<IPaintable>(){

                public NBTBase writeNBT(Capability<IPaintable> capability, IPaintable instance, EnumFacing side) {
                    IBlockState paint = instance.getPaint();
                    return new NBTTagInt(paint == null ? 0 : Block.func_176210_f((IBlockState)paint));
                }

                public void readNBT(Capability<IPaintable> capability, IPaintable instance, EnumFacing side, NBTBase base) {
                    int paint = ((NBTTagInt)base).func_150287_d();
                    instance.setPaint(paint == 0 ? null : Block.func_176220_d((int)paint));
                }
            }, PaintStorage::new);
            CapabilityManager.INSTANCE.register(IPainterItem.class, (Capability.IStorage)new Capability.IStorage<IPainterItem>(){

                public NBTBase writeNBT(Capability<IPainterItem> capability, IPainterItem instance, EnumFacing side) {
                    IBlockState paint = instance.getPaint();
                    return new NBTTagInt(paint == null ? 0 : Block.func_176210_f((IBlockState)paint));
                }

                public void readNBT(Capability<IPainterItem> capability, IPainterItem instance, EnumFacing side, NBTBase base) {
                    int paint = ((NBTTagInt)base).func_150287_d();
                    instance.setPaint(paint == 0 ? null : Block.func_176220_d((int)paint));
                }
            }, PainterItemStorage::new);
            CapabilityManager.INSTANCE.register(ISecure.class, (Capability.IStorage)ISecureStorage.INSTANCE, () -> new Security(true, false));
        }
    }
}

