/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.events.ForgePlayerEvent;
import com.latmod.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgePlayer
implements Comparable<ForgePlayer>,
ICapabilityProvider {
    public final Map<EntityEquipmentSlot, ItemStack> lastArmor;
    final CapabilityDispatcher capabilities;
    private String teamID;
    private GameProfile gameProfile;

    ForgePlayer(GameProfile p) {
        this.setProfile(p);
        this.lastArmor = new HashMap<EntityEquipmentSlot, ItemStack>();
        ForgePlayerEvent.AttachCapabilities event = new ForgePlayerEvent.AttachCapabilities(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = !event.getCapabilities().isEmpty() ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    public final String getTeamID() {
        return this.teamID;
    }

    public final void setTeamID(String id) {
        this.teamID = id == null || id.isEmpty() ? null : id;
    }

    public final boolean isMemberOf(ForgeTeam team) {
        return this.teamID != null && team != null && team.getID().equals(this.teamID);
    }

    public final boolean hasTeam() {
        return this.teamID != null && this.getWorld().teams.containsKey(this.teamID);
    }

    @Nullable
    public final ForgeTeam getTeam() {
        return this.teamID != null ? this.getWorld().teams.get(this.teamID) : null;
    }

    public final boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilities != null && this.capabilities.hasCapability(capability, facing);
    }

    public final <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    public abstract EntityPlayer getPlayer();

    public abstract ForgePlayerMP toMP();

    @SideOnly(value=Side.CLIENT)
    public abstract ForgePlayerSP toSP();

    public abstract ForgeWorld getWorld();

    public final GameProfile getProfile() {
        return this.gameProfile;
    }

    public final void setProfile(GameProfile p) {
        if (p != null) {
            this.gameProfile = new GameProfile(p.getId(), p.getName());
        }
    }

    public final String getStringUUID() {
        return LMUtils.fromUUID(this.gameProfile.getId());
    }

    @Override
    public final int compareTo(@Nonnull ForgePlayer o) {
        return this.getProfile().getName().compareToIgnoreCase(o.getProfile().getName());
    }

    public final String toString() {
        return this.gameProfile.getName();
    }

    public final int hashCode() {
        return this.gameProfile.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof UUID) {
            return this.gameProfile.getId().equals(o);
        }
        if (o instanceof ForgePlayer) {
            return this.equalsPlayer((ForgePlayer)o);
        }
        return this.equalsPlayer(this.getWorld().getPlayer(o));
    }

    public boolean equalsPlayer(ForgePlayer p) {
        return p != null && (p == this || this.gameProfile.getId().equals(p.gameProfile.getId()));
    }

    public boolean isMCPlayer() {
        return false;
    }

    public void updateArmor() {
        EntityPlayer ep;
        if (this.getWorld().getSide().isServer() && (ep = this.getPlayer()) != null) {
            this.lastArmor.clear();
            for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
                ItemStack is = ep.func_184582_a(e);
                if (is == null) continue;
                this.lastArmor.put(e, is.func_77946_l());
            }
        }
    }

    public void onLoggedIn(boolean firstLogin) {
        this.updateArmor();
    }

    public void onLoggedOut() {
        this.updateArmor();
    }

    public void onDeath() {
        this.updateArmor();
    }

    public void sendUpdate() {
    }

    public void sendInfoUpdate(ForgePlayer p) {
    }
}

