/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.FTBLibStats;
import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.config.ConfigEntryEnum;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.feed_the_beast.ftbl.api.events.ForgePlayerEvent;
import com.feed_the_beast.ftbl.api.item.LMInvUtils;
import com.feed_the_beast.ftbl.net.MessageLMPlayerInfo;
import com.feed_the_beast.ftbl.net.MessageLMPlayerLoggedIn;
import com.feed_the_beast.ftbl.net.MessageLMPlayerLoggedOut;
import com.feed_the_beast.ftbl.net.MessageLMPlayerUpdate;
import com.feed_the_beast.ftbl.net.MessageReload;
import com.feed_the_beast.ftbl.util.BlockDimPos;
import com.feed_the_beast.ftbl.util.EntityDimPos;
import com.feed_the_beast.ftbl.util.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.ReloadType;
import com.latmod.lib.util.LMStringUtils;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgePlayerMP
extends ForgePlayer
implements INBTSerializable<NBTTagCompound> {
    public final ConfigEntryEnum<EnumNotificationDisplay> notifications = new ConfigEntryEnum<EnumNotificationDisplay>(EnumNotificationDisplay.SCREEN, EnumNotificationDisplay.NAME_MAP);
    public BlockDimPos lastPos;
    public BlockDimPos lastDeath;
    private StatisticsManagerServer statsManager;
    private EntityPlayerMP entityPlayer;

    public ForgePlayerMP(GameProfile p) {
        super(p);
    }

    public static ForgePlayerMP get(Object o) throws CommandException {
        ForgePlayerMP p = ForgeWorldMP.inst.getPlayer(o);
        if (p == null || p.isFake()) {
            throw new PlayerNotFoundException();
        }
        return p;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public EntityPlayerMP getPlayer() {
        return this.entityPlayer;
    }

    public void setPlayer(EntityPlayerMP ep) {
        this.entityPlayer = ep;
    }

    @Override
    public final ForgePlayerMP toMP() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final ForgePlayerSP toSP() {
        return null;
    }

    @Override
    public final ForgeWorldMP getWorld() {
        return ForgeWorldMP.inst;
    }

    public boolean isFake() {
        return this.getPlayer() instanceof FakePlayer;
    }

    @Override
    public void sendUpdate() {
        EntityPlayerMP player = this.getPlayer();
        if (this.isOnline()) {
            new MessageLMPlayerUpdate(this, true).sendTo(player);
        }
        for (EntityPlayerMP ep : FTBLib.getServer().func_184103_al().func_181057_v()) {
            if (ep == player) continue;
            new MessageLMPlayerUpdate(this, false).sendTo(ep);
        }
    }

    @Override
    public void sendInfoUpdate(ForgePlayer p) {
        new MessageLMPlayerInfo(this, p.toMP()).sendTo(this.getPlayer());
    }

    public boolean isOP() {
        return FTBLib.isOP(this.getProfile());
    }

    public BlockDimPos getPos() {
        EntityPlayerMP ep = this.getPlayer();
        if (ep != null) {
            this.lastPos = new EntityDimPos((Entity)ep).toBlockDimPos();
        }
        return this.lastPos == null ? null : this.lastPos.copy();
    }

    public void getInfo(ForgePlayerMP owner, List<ITextComponent> info) {
        long firstJoined;
        long lastSeen;
        long ms = System.currentTimeMillis();
        ForgeTeam team = this.getTeam();
        if (team != null) {
            TextComponentString c = new TextComponentString("[" + team.getTitle() + "]");
            c.func_150256_b().func_150238_a(team.getColor().textFormatting).func_150228_d(Boolean.valueOf(true));
            info.add((ITextComponent)c);
            if (team.getDesc() != null) {
                c = new TextComponentString(team.getDesc());
                c.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
                info.add((ITextComponent)c);
            }
            info.add(null);
        }
        StatisticsManagerServer stats = this.stats();
        if (!owner.isOnline() && (lastSeen = FTBLibStats.getLastSeen(stats, false)) > 0L) {
            info.add(new TextComponentTranslation(FTBLibStats.LAST_SEEN.field_75975_e, new Object[0]).func_150258_a(": " + LMStringUtils.getTimeString(ms - lastSeen)));
        }
        if ((firstJoined = FTBLibStats.getFirstJoined(stats)) > 0L) {
            info.add(new TextComponentTranslation(FTBLibStats.FIRST_JOINED.field_75975_e, new Object[0]).func_150258_a(": " + LMStringUtils.getTimeString(ms - firstJoined)));
        }
        if (stats.func_77444_a(StatList.field_188069_A) > 0) {
            info.add(new TextComponentTranslation(StatList.field_188069_A.field_75975_e, new Object[0]).func_150258_a(": " + stats.func_77444_a(StatList.field_188069_A)));
        }
        if ((long)stats.func_77444_a(StatList.field_188097_g) > 0L) {
            ITextComponent c = StatList.field_188097_g.func_150951_e();
            c.func_150256_b().func_150238_a(null);
            info.add(c.func_150257_a((ITextComponent)new TextComponentString(": " + LMStringUtils.getTimeString((long)stats.func_77444_a(StatList.field_188097_g) * 50L))));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.AddInfo(this, info, ms));
    }

    public void deserializeNBT(NBTTagCompound tag) {
        int[] ai;
        this.setTeamID(tag.func_74779_i("TeamID"));
        if (this.capabilities != null) {
            this.capabilities.deserializeNBT(tag.func_74775_l("Caps"));
        }
        this.lastArmor.clear();
        if (tag.func_74764_b("LastItems")) {
            ItemStack[] lastArmorItems = new ItemStack[EntityEquipmentSlot.values().length];
            LMInvUtils.readItemsFromNBT(lastArmorItems, tag, "Armor");
            for (int i = 0; i < lastArmorItems.length; ++i) {
                if (lastArmorItems[i] == null) continue;
                this.lastArmor.put(EntityEquipmentSlot.values()[i], lastArmorItems[i]);
            }
        }
        this.lastPos = null;
        if (tag.func_74764_b("Pos")) {
            ai = tag.func_74759_k("LastPos");
            this.lastPos = ai.length == 4 ? new BlockDimPos(ai) : null;
        }
        this.lastDeath = null;
        if (tag.func_74764_b("LastDeath")) {
            ai = tag.func_74759_k("LastDeath");
            this.lastDeath = ai.length == 4 ? new BlockDimPos(ai) : null;
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.hasTeam()) {
            tag.func_74778_a("TeamID", this.getTeamID());
        }
        if (this.capabilities != null) {
            tag.func_74782_a("Caps", (NBTBase)this.capabilities.serializeNBT());
        }
        if (!this.lastArmor.isEmpty()) {
            ItemStack[] lastArmorItems = new ItemStack[EntityEquipmentSlot.values().length];
            for (Map.Entry e : this.lastArmor.entrySet()) {
                lastArmorItems[((EntityEquipmentSlot)e.getKey()).ordinal()] = (ItemStack)e.getValue();
            }
            LMInvUtils.writeItemsToNBT(lastArmorItems, tag, "Armor");
        }
        if (this.getPos() != null) {
            tag.func_74783_a("Pos", this.lastPos.toIntArray());
        }
        if (this.lastDeath != null) {
            tag.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        return tag;
    }

    public void writeToNet(NBTTagCompound tag, boolean self) {
        NBTTagCompound syncData = new NBTTagCompound();
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.Sync(this, syncData, self));
        if (!syncData.func_82582_d()) {
            tag.func_74782_a("SY", (NBTBase)syncData);
        }
        if (this.hasTeam()) {
            tag.func_74778_a("T", this.getTeamID());
        }
    }

    @Override
    public void onLoggedIn(boolean firstLogin) {
        super.onLoggedIn(firstLogin);
        FTBLibStats.updateLastSeen(this.stats());
        EntityPlayerMP ep = this.getPlayer();
        new MessageLMPlayerLoggedIn(this, firstLogin, true).sendTo(ep);
        new MessageReload(ReloadType.CLIENT_ONLY, this, true).sendTo(ep);
        for (EntityPlayerMP ep1 : FTBLib.getServer().func_184103_al().func_181057_v()) {
            if (ep1 == ep) continue;
            new MessageLMPlayerLoggedIn(this, firstLogin, false).sendTo(ep1);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.LoggedIn(this, firstLogin));
    }

    @Override
    public void onLoggedOut() {
        FTBLibStats.updateLastSeen(this.stats());
        super.onLoggedOut();
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.LoggedOut(this));
        new MessageLMPlayerLoggedOut(this).sendTo(null);
    }

    @Override
    public void onDeath() {
        if (this.isOnline()) {
            this.lastDeath = new EntityDimPos((Entity)this.getPlayer()).toBlockDimPos();
            super.onDeath();
            FTBLibStats.updateLastSeen(this.stats());
            MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.OnDeath(this));
        }
    }

    @Nonnull
    public StatisticsManagerServer stats() {
        if (this.statsManager == null) {
            this.statsManager = FTBLib.getServer().func_184103_al().func_152602_a((EntityPlayer)(this.entityPlayer == null ? new FakePlayer(FTBLib.getServerWorld(), this.getProfile()) : this.entityPlayer));
        }
        return this.statsManager;
    }

    public void getSettings(ConfigGroup group) {
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerEvent.GetSettings(this, group));
        group.add("notifications", this.notifications);
    }
}

