/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.api.config.ConfigEntryEnum;
import com.feed_the_beast.ftbl.api.config.ConfigEntryString;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.feed_the_beast.ftbl.api.config.EnumNameMap;
import com.feed_the_beast.ftbl.api.events.ForgeTeamEvent;
import com.feed_the_beast.ftbl.api.security.EnumTeamPrivacyLevel;
import com.latmod.lib.FinalIDObject;
import com.latmod.lib.annotations.IFlagContainer;
import com.latmod.lib.util.LMUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ForgeTeam
extends FinalIDObject
implements ICapabilitySerializable<NBTTagCompound>,
IFlagContainer {
    public static final byte FREE_TO_JOIN = 1;
    public static final byte HIDDEN = 2;
    public final ForgeWorld world;
    private final CapabilityDispatcher capabilities;
    private final ConfigEntryEnum<EnumTeamColor> color;
    private ForgePlayer owner;
    private Collection<String> allies;
    private Collection<UUID> enemies;
    private String title;
    private String desc;
    private int flags;
    private Collection<ForgePlayerMP> invited;

    public ForgeTeam(ForgeWorld w, String id) {
        super(id);
        this.world = w;
        this.color = new ConfigEntryEnum<EnumTeamColor>(EnumTeamColor.BLUE, EnumTeamColor.NAME_MAP);
        ForgeTeamEvent.AttachCapabilities event = new ForgeTeamEvent.AttachCapabilities(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = !event.getCapabilities().isEmpty() ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    public final boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilities != null && this.capabilities.hasCapability(capability, facing);
    }

    public final <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int f) {
        this.flags = f;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Owner", LMUtils.fromUUID(this.owner.getProfile().getId()));
        nbt.func_74774_a("Flags", (byte)this.flags);
        nbt.func_74778_a("Color", EnumNameMap.getEnumName(this.color.get()));
        if (this.title != null) {
            nbt.func_74778_a("Title", this.title);
        }
        if (this.desc != null) {
            nbt.func_74778_a("Desc", this.desc);
        }
        if (this.capabilities != null) {
            nbt.func_74782_a("Caps", (NBTBase)this.capabilities.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.owner = this.world.getPlayer(LMUtils.fromString(nbt.func_74779_i("Owner")));
        this.flags = nbt.func_74771_c("Flags");
        this.color.set((Object)(nbt.func_74764_b("Color") ? EnumTeamColor.NAME_MAP.get(nbt.func_74779_i("Color")) : EnumTeamColor.GRAY));
        this.title = nbt.func_74764_b("Title") ? nbt.func_74779_i("Title") : null;
        String string = this.desc = nbt.func_74764_b("Desc") ? nbt.func_74779_i("Desc") : null;
        if (this.capabilities != null) {
            this.capabilities.deserializeNBT(nbt.func_74775_l("Caps"));
        }
    }

    public NBTTagCompound serializeNBTForNet(ForgePlayerMP to) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("OM", this.owner.getProfile().getId().getMostSignificantBits());
        tag.func_74772_a("OL", this.owner.getProfile().getId().getLeastSignificantBits());
        if (this.flags != 0) {
            tag.func_74774_a("F", (byte)this.flags);
        }
        tag.func_74774_a("C", (byte)this.color.getIndex());
        if (this.title != null) {
            tag.func_74778_a("T", this.title);
        }
        if (this.desc != null) {
            tag.func_74778_a("D", this.desc);
        }
        NBTTagCompound sync = new NBTTagCompound();
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.Sync(this, Side.SERVER, sync, to));
        if (!sync.func_82582_d()) {
            tag.func_74782_a("SY", (NBTBase)sync);
        }
        return tag;
    }

    public void deserializeNBTFromNet(NBTTagCompound nbt) {
        this.owner = this.world.getPlayer(new UUID(nbt.func_74763_f("OM"), nbt.func_74763_f("OL")));
        this.flags = nbt.func_74771_c("F");
        this.color.setIndex(nbt.func_74771_c("C"));
        this.title = nbt.func_74764_b("T") ? nbt.func_74779_i("T") : null;
        this.desc = nbt.func_74764_b("D") ? nbt.func_74779_i("D") : null;
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.Sync(this, Side.CLIENT, nbt.func_74775_l("SY"), ForgeWorldSP.inst.clientPlayer));
    }

    public ForgePlayer getOwner() {
        return this.owner;
    }

    public String getTitle() {
        return this.title == null ? this.owner.getProfile().getName() + "'s Team" : this.title;
    }

    public void setTitle(@Nullable String s) {
        this.title = s == null || s.isEmpty() ? null : s;
    }

    @Nullable
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(@Nullable String s) {
        this.desc = s == null || s.isEmpty() ? null : s;
    }

    public EnumTeamColor getColor() {
        return this.color.get();
    }

    public void setColor(EnumTeamColor col) {
        this.color.set((Object)col);
    }

    public EnumTeamStatus getStatus(@Nullable ForgePlayer player) {
        if (player == null) {
            return EnumTeamStatus.NONE;
        }
        if (this.owner.equalsPlayer(player)) {
            return EnumTeamStatus.OWNER;
        }
        if (this.enemies != null && this.enemies.contains(player.getProfile().getId())) {
            return EnumTeamStatus.ENEMY;
        }
        if (player.hasTeam()) {
            ForgeTeam team = player.getTeam();
            if (team.equals(this)) {
                return EnumTeamStatus.MEMBER;
            }
            if (this.allies != null && this.allies.contains(team.getID())) {
                return EnumTeamStatus.ALLY;
            }
        }
        return EnumTeamStatus.NONE;
    }

    public boolean addAllyTeam(String team) {
        if (!this.isAllyTeam(team)) {
            if (this.allies == null) {
                this.allies = new HashSet<String>();
            }
            this.allies.add(team);
            return true;
        }
        return false;
    }

    public boolean removeAllyTeam(String team) {
        if (this.isAllyTeam(team)) {
            this.allies.remove(team);
            if (this.allies.isEmpty()) {
                this.allies = null;
            }
            return true;
        }
        return false;
    }

    public boolean isAllyTeam(String team) {
        return this.allies != null && this.allies.contains(team);
    }

    public boolean addEnemy(UUID player) {
        if (!this.isEnemy(player)) {
            if (this.enemies == null) {
                this.enemies = new HashSet<UUID>();
            }
            this.enemies.add(player);
            return true;
        }
        return false;
    }

    public boolean removeEnemy(UUID player) {
        if (this.isEnemy(player)) {
            this.enemies.remove(player);
            if (this.enemies.isEmpty()) {
                this.enemies = null;
            }
            return true;
        }
        return false;
    }

    public boolean isEnemy(UUID player) {
        return this.enemies != null && this.enemies.contains(player);
    }

    public Collection<ForgePlayer> getMembers() {
        HashSet<ForgePlayer> c = new HashSet<ForgePlayer>();
        for (ForgePlayer p : this.world.playerMap.values()) {
            if (!this.getStatus(p).isMember()) continue;
            c.add(p);
        }
        return c;
    }

    public boolean addPlayer(ForgePlayerMP player) {
        if (!player.isMemberOf(this) && this.isInvited(player)) {
            player.setTeamID(this.getID());
            MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.PlayerJoined(this, player));
            this.invited.remove(player);
            return true;
        }
        return false;
    }

    public void removePlayer(ForgePlayerMP player) {
        if (player.isMemberOf(this)) {
            player.setTeamID(null);
            MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.PlayerLeft(this, player));
        }
    }

    public boolean inviteMember(@Nullable ForgePlayerMP player) {
        if (!this.isInvited(player)) {
            if (this.invited == null) {
                this.invited = new HashSet<ForgePlayerMP>();
            }
            this.invited.add(player);
            return true;
        }
        return false;
    }

    public boolean isInvited(@Nullable ForgePlayerMP player) {
        return player != null && ((this.getFlags() & 1) != 0 || this.invited != null && this.invited.contains(player) && !player.hasTeam());
    }

    public void changeOwner(ForgePlayerMP newOwner) {
        if (this.owner == null) {
            this.owner = newOwner;
            newOwner.setTeamID(this.getID());
        } else {
            ForgePlayerMP oldOwner = this.owner.toMP();
            if (!oldOwner.equalsPlayer(newOwner) && newOwner.isMemberOf(this)) {
                this.owner = newOwner;
                MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.OwnerChanged(this, oldOwner, newOwner));
            }
        }
    }

    public boolean canInteract(ForgePlayer player, EnumTeamPrivacyLevel level) {
        switch (level) {
            case EVERYONE: {
                return true;
            }
            case MEMBERS: {
                return this.getStatus(player).isMember();
            }
            case ALLIES: {
                return this.getStatus(player).isAlly();
            }
        }
        return false;
    }

    public void getSettings(ConfigGroup group) {
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.GetSettings(this, group));
        group.add("color", this.color);
        group.add("title", new ConfigEntryString(this.title == null ? "" : this.title){

            @Override
            public void set(String v) {
                ForgeTeam.this.setTitle(v.trim());
            }

            @Override
            public String getAsString() {
                return ForgeTeam.this.title == null ? "" : ForgeTeam.this.title;
            }
        });
        group.add("desc", new ConfigEntryString(this.desc == null ? "" : this.desc){

            @Override
            public void set(String v) {
                ForgeTeam.this.setDesc(v.trim());
            }

            @Override
            public String getAsString() {
                return ForgeTeam.this.desc == null ? "" : ForgeTeam.this.desc;
            }
        });
        group.add("free_to_join", new ConfigEntryBool(false){

            @Override
            public void set(boolean v) {
                this.setFlag(1, v);
            }

            @Override
            public boolean getAsBoolean() {
                return this.getFlag(1);
            }
        });
        group.add("is_hidden", new ConfigEntryBool(false){

            @Override
            public void set(boolean v) {
                this.setFlag(2, v);
            }

            @Override
            public boolean getAsBoolean() {
                return this.getFlag(2);
            }
        });
    }
}

