/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.PackMode;
import com.feed_the_beast.ftbl.api.PackModes;
import com.feed_the_beast.ftbl.api.events.ForgeWorldEvent;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.latmod.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgeWorld
implements ICapabilityProvider {
    public final Map<UUID, ForgePlayer> playerMap;
    public final Map<String, ForgeTeam> teams;
    final CapabilityDispatcher capabilities;
    protected UUID worldID;
    protected PackMode currentMode = new PackMode("default");

    ForgeWorld() {
        this.playerMap = new HashMap<UUID, ForgePlayer>();
        this.teams = new HashMap<String, ForgeTeam>();
        ForgeWorldEvent.AttachCapabilities event = new ForgeWorldEvent.AttachCapabilities(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = !event.getCapabilities().isEmpty() ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
        MinecraftForge.EVENT_BUS.post((Event)new ForgeWorldEvent.Loaded(this));
    }

    public static ForgeWorld getFrom(Side side) {
        if (side == null) {
            return ForgeWorld.getFrom(FTBLib.getEffectiveSide());
        }
        if (side.isServer()) {
            return ForgeWorldMP.inst;
        }
        return ForgeWorldSP.inst;
    }

    public abstract Side getSide();

    public final UUID getID() {
        if (this.worldID == null || this.worldID.getLeastSignificantBits() == 0L && this.worldID.getMostSignificantBits() == 0L) {
            this.worldID = UUID.randomUUID();
        }
        return this.worldID;
    }

    public final boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilities != null && this.capabilities.hasCapability(capability, facing);
    }

    public final <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    public abstract World getMCWorld();

    public abstract ForgeWorldMP toWorldMP();

    @SideOnly(value=Side.CLIENT)
    public abstract ForgeWorldSP toWorldSP();

    public PackMode getMode() {
        return this.currentMode;
    }

    public ForgePlayer getPlayer(Object o) {
        if (o == null || o instanceof FakePlayer) {
            return null;
        }
        if (o instanceof UUID) {
            UUID id = (UUID)o;
            if (id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L) {
                return null;
            }
            return this.playerMap.get(id);
        }
        if (o instanceof ForgePlayer) {
            return this.getPlayer(((ForgePlayer)o).getProfile().getId());
        }
        if (o instanceof EntityPlayer) {
            return this.getPlayer(((EntityPlayer)o).func_146103_bH().getId());
        }
        if (o instanceof GameProfile) {
            return this.getPlayer(((GameProfile)o).getId());
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (ForgePlayer p : this.playerMap.values()) {
                if (!p.getProfile().getName().equalsIgnoreCase(s)) continue;
                return p;
            }
            return this.getPlayer(LMUtils.fromString(s));
        }
        return null;
    }

    public final int setMode(String mode) {
        PackMode m = PackModes.instance().getRawMode(mode);
        if (m == null) {
            return 1;
        }
        if (m.equals(this.currentMode)) {
            return 2;
        }
        this.currentMode = m;
        return 0;
    }

    public void onClosed() {
        MinecraftForge.EVENT_BUS.post((Event)new ForgeWorldEvent.Closed(this));
        this.playerMap.clear();
    }
}

