/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerFake;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.PackModes;
import com.feed_the_beast.ftbl.api.events.ForgeWorldEvent;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.LMNBTUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ForgeWorldMP
extends ForgeWorld {
    public static ForgeWorldMP inst = null;
    public static ForgePlayerMP currentPlayer;
    public static ForgeTeam currentTeam;

    public ForgeWorldMP() {
        this.currentMode = PackModes.instance().getDefault();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public World getMCWorld() {
        return FTBLib.getServer().func_130014_f_();
    }

    @Override
    public ForgeWorldMP toWorldMP() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ForgeWorldSP toWorldSP() {
        return null;
    }

    @Override
    public ForgePlayerMP getPlayer(Object o) {
        if (o instanceof FakePlayer) {
            return new ForgePlayerFake((FakePlayer)o);
        }
        ForgePlayer p = super.getPlayer(o);
        return p == null ? null : p.toMP();
    }

    public void load() throws Exception {
        JsonElement worldData = LMJsonUtils.fromJson(new File(FTBLib.folderWorld, "world_data.json"));
        if (worldData.isJsonObject()) {
            JsonObject group = worldData.getAsJsonObject();
            this.worldID = group.has("world_id") ? LMUtils.fromString(group.get("world_id").getAsString()) : null;
            this.getID();
            this.currentMode = group.has("mode") ? PackModes.instance().getMode(group.get("mode").getAsString()) : PackModes.instance().getDefault();
        }
        this.playerMap.clear();
        NBTTagCompound nbt = LMNBTUtils.readTag(new File(FTBLib.folderWorld, "data/FTBLib.dat"));
        if (nbt != null) {
            if (this.capabilities != null) {
                this.capabilities.deserializeNBT(nbt.func_74775_l("ForgeCaps"));
            }
            MinecraftForge.EVENT_BUS.post((Event)new ForgeWorldEvent.LoadedBeforePlayers(this));
            NBTTagList list = nbt.func_150295_c("Players", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ForgePlayerMP p;
                NBTTagCompound tag = list.func_150305_b(i);
                UUID id = LMUtils.fromString(tag.func_74779_i("UUID"));
                if (id == null) continue;
                currentPlayer = p = new ForgePlayerMP(new GameProfile(id, tag.func_74779_i("Name")));
                p.deserializeNBT(tag);
                this.playerMap.put(id, p);
            }
            currentPlayer = null;
            this.teams.clear();
            NBTTagList teamsTag = nbt.func_150295_c("Teams", 10);
            for (int i = 0; i < teamsTag.func_74745_c(); ++i) {
                ForgeTeam team;
                NBTTagCompound tag2 = teamsTag.func_150305_b(i);
                currentTeam = team = new ForgeTeam(this, tag2.func_74779_i("ID"));
                team.deserializeNBT(tag2);
                this.teams.put(team.getID(), team);
            }
            currentTeam = null;
            MinecraftForge.EVENT_BUS.post((Event)new ForgeWorldEvent.PostLoaded(this));
        }
    }

    public void save() throws Exception {
        NBTTagCompound tag2;
        JsonObject group = new JsonObject();
        group.add("world_id", (JsonElement)new JsonPrimitive(LMUtils.fromUUID(this.getID())));
        group.add("mode", (JsonElement)new JsonPrimitive(this.currentMode.getID()));
        LMJsonUtils.toJson(new File(FTBLib.folderWorld, "world_data.json"), (JsonElement)group);
        FTBLib.dev_logger.info("ForgeWorldMP Saved: " + group);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.capabilities != null) {
            tag.func_74782_a("ForgeCaps", (NBTBase)this.capabilities.serializeNBT());
        }
        NBTTagList tagPlayers = new NBTTagList();
        for (ForgePlayer p : this.playerMap.values()) {
            currentPlayer = p.toMP();
            tag2 = p.toMP().serializeNBT();
            tag2.func_74778_a("Name", p.getProfile().getName());
            tag2.func_74778_a("UUID", p.getStringUUID());
            tagPlayers.func_74742_a((NBTBase)tag2);
        }
        currentPlayer = null;
        tag.func_74782_a("Players", (NBTBase)tagPlayers);
        NBTTagList teamsTag = new NBTTagList();
        Iterator iterator = this.teams.values().iterator();
        while (iterator.hasNext()) {
            ForgeTeam team;
            currentTeam = team = (ForgeTeam)iterator.next();
            tag2 = team.serializeNBT();
            tag2.func_74778_a("ID", team.getID());
            teamsTag.func_74742_a((NBTBase)tag2);
        }
        currentTeam = null;
        tag.func_74782_a("Teams", (NBTBase)teamsTag);
        LMNBTUtils.writeTag(new File(FTBLib.folderWorld, "data/FTBLib.dat"), tag);
        FTBLib.dev_logger.info("ForgeWorldMP Saved: " + tag);
    }

    public void writeDataToNet(NBTTagCompound tag, ForgePlayerMP self, boolean login) {
        tag.func_74772_a("IDM", this.getID().getMostSignificantBits());
        tag.func_74772_a("IDL", this.getID().getLeastSignificantBits());
        tag.func_74778_a("M", this.currentMode.getID());
        if (login) {
            NBTTagCompound tag2;
            NBTTagCompound tag1 = new NBTTagCompound();
            HashSet<ForgePlayerMP> onlinePlayers = new HashSet<ForgePlayerMP>();
            for (ForgePlayer forgePlayer : this.playerMap.values()) {
                tag1.func_74778_a(forgePlayer.getStringUUID(), forgePlayer.getProfile().getName());
                if (!forgePlayer.toMP().isOnline() || forgePlayer.equalsPlayer(self)) continue;
                onlinePlayers.add(forgePlayer.toMP());
            }
            if (!tag1.func_82582_d()) {
                tag.func_74782_a("PM", (NBTBase)tag1);
            }
            tag1 = new NBTTagCompound();
            for (ForgePlayerMP forgePlayerMP : onlinePlayers) {
                tag2 = new NBTTagCompound();
                forgePlayerMP.writeToNet(tag2, false);
                tag1.func_74782_a(forgePlayerMP.getStringUUID(), (NBTBase)tag2);
            }
            tag2 = new NBTTagCompound();
            self.writeToNet(tag2, true);
            tag1.func_74782_a(self.getStringUUID(), (NBTBase)tag2);
            if (!tag1.func_82582_d()) {
                tag.func_74782_a("PMD", (NBTBase)tag1);
            }
            NBTTagList teamsTag = new NBTTagList();
            for (ForgeTeam team : this.teams.values()) {
                tag2 = team.serializeNBTForNet(self);
                tag2.func_74778_a("ID", team.getID());
                teamsTag.func_74742_a((NBTBase)tag2);
            }
            tag.func_74782_a("TMS", (NBTBase)teamsTag);
        }
    }

    public Collection<ForgePlayerMP> getOnlinePlayers() {
        HashSet<ForgePlayerMP> l = new HashSet<ForgePlayerMP>();
        for (ForgePlayer p : this.playerMap.values()) {
            ForgePlayerMP pmp = p.toMP();
            if (!pmp.isOnline()) continue;
            l.add(pmp);
        }
        return l;
    }
}

