/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.PackMode;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMFileUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PackModes {
    private static PackModes inst = null;
    private final Map<String, PackMode> modes;
    private final PackMode defaultMode;
    private final PackMode commonMode;
    private final Map<String, JsonElement> customData;

    public PackModes(JsonElement el) {
        JsonObject o = PackModes.isValid(el) ? el.getAsJsonObject() : PackModes.createDefault();
        HashMap<String, PackMode> modes0 = new HashMap<String, PackMode>();
        JsonArray a = o.get("modes").getAsJsonArray();
        for (int i = 0; i < a.size(); ++i) {
            PackMode m = new PackMode(a.get(i).getAsString());
            modes0.put(m.getID(), m);
        }
        this.defaultMode = (PackMode)modes0.get(o.get("default").getAsString());
        if (modes0.containsKey("common")) {
            throw new RuntimeException("FTBLib: 'common' can't be one of 'modes'!");
        }
        this.commonMode = new PackMode("common");
        this.modes = Collections.unmodifiableMap(modes0);
        HashMap customData0 = new HashMap();
        if (o.has("custom")) {
            JsonObject o1 = o.get("custom").getAsJsonObject();
            for (Map.Entry e : o1.entrySet()) {
                customData0.put(e.getKey(), e.getValue());
            }
        }
        this.customData = Collections.unmodifiableMap(customData0);
    }

    private static JsonObject createDefault() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        a.add((JsonElement)new JsonPrimitive("default"));
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive("default"));
        o.add("common", (JsonElement)new JsonPrimitive("common"));
        return o;
    }

    private static boolean isValid(JsonElement e) {
        if (e == null || !e.isJsonObject()) {
            return false;
        }
        JsonObject o = e.getAsJsonObject();
        return o != null && !o.entrySet().isEmpty() && o.has("modes") && o.has("default") && o.has("common");
    }

    public static void reload() {
        File file = LMFileUtils.newFile(new File(FTBLib.folderModpack, "packmodes.json"));
        inst = new PackModes(LMJsonUtils.fromJson(file));
        LMJsonUtils.toJson(file, (JsonElement)inst.toJsonObject());
    }

    public static PackModes instance() {
        if (inst == null) {
            PackModes.reload();
        }
        return inst;
    }

    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        for (PackMode m : this.modes.values()) {
            a.add((JsonElement)new JsonPrimitive(m.getID()));
        }
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive(this.defaultMode.getID()));
        o.add("common", (JsonElement)new JsonPrimitive(this.commonMode.getID()));
        if (!this.customData.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (Map.Entry<String, JsonElement> e : this.customData.entrySet()) {
                o1.add(e.getKey(), e.getValue());
            }
            o.add("custom", (JsonElement)o1);
        }
        return o;
    }

    public Collection<String> getModes() {
        return this.modes.keySet();
    }

    public PackMode getRawMode(String s) {
        return s == null || s.isEmpty() ? null : this.modes.get(s);
    }

    public PackMode getMode(String s) {
        if (s == null || s.isEmpty()) {
            return this.defaultMode;
        }
        PackMode m = this.modes.get(s);
        return m == null ? this.defaultMode : m;
    }

    public PackMode getDefault() {
        return this.defaultMode;
    }

    public PackMode getCommon() {
        return this.commonMode;
    }

    public JsonElement getCustomData(String s) {
        return s != null && !s.isEmpty() && this.customData.containsKey(s) ? this.customData.get(s) : JsonNull.INSTANCE;
    }
}

