/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.util.FTBLib;
import com.latmod.lib.IIDObject;
import com.latmod.lib.util.LMUtils;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationObject
implements IIDObject {
    public static final Comparator<Object> COMPARATOR = (o1, o2) -> FTBLib.RESOURCE_LOCATION_COMPARATOR.compare(ResourceLocationObject.getResourceLocation(o1), ResourceLocationObject.getResourceLocation(o2));
    private final ResourceLocation ID;

    public ResourceLocationObject(ResourceLocation id) {
        if (id == null) {
            throw new NullPointerException("ID can't be null!");
        }
        this.ID = id;
    }

    public static ResourceLocation getResourceLocation(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ResourceLocation) {
            return (ResourceLocation)o;
        }
        if (o instanceof ResourceLocationObject) {
            return ((ResourceLocationObject)o).getResourceLocation();
        }
        return null;
    }

    public final ResourceLocation getResourceLocation() {
        return this.ID;
    }

    @Override
    @Nonnull
    public final String getID() {
        return this.ID.toString();
    }

    public String toString() {
        return this.getID();
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ResourceLocationObject) {
            return ((ResourceLocationObject)o).getResourceLocation().equals((Object)this.ID);
        }
        if (o instanceof ResourceLocation) {
            return o.equals(this.ID);
        }
        return LMUtils.getID(o).equals(this.getID());
    }

    public final int hashCode() {
        return this.ID.hashCode();
    }
}

