/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client;

import com.feed_the_beast.ftbl.api.client.gui.IClientActionGui;
import com.latmod.lib.util.LMColorUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;

@SideOnly(value=Side.CLIENT)
public class FTBLibClient {
    private static final Map<String, ResourceLocation> cachedSkins = new HashMap<String, ResourceLocation>();
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static EntityItem entityItem;

    public static <T extends Entity> void addEntityRenderer(@Nonnull Class<T> c, @Nonnull IRenderFactory<? super T> r) {
        RenderingRegistry.registerEntityRenderingHandler(c, r);
    }

    public static <T extends TileEntity> void addTileRenderer(@Nonnull Class<T> c, @Nonnull TileEntitySpecialRenderer<? super T> r) {
        ClientRegistry.bindTileEntitySpecialRenderer(c, r);
    }

    @Nonnull
    public static KeyBinding addKeyBinding(@Nonnull KeyBinding k) {
        ClientRegistry.registerKeyBinding((KeyBinding)k);
        return k;
    }

    public static int getDim() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null ? mc.field_71441_e.field_73011_w.getDimension() : 0;
    }

    public static void spawnPart(@Nonnull Particle e) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(e);
    }

    public static void onGuiClientAction() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof IClientActionGui) {
            ((IClientActionGui)screen).onClientDataChanged();
        }
    }

    public static void pushMaxBrightness() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void popMaxBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static ThreadDownloadImageData getDownloadImage(@Nonnull ResourceLocation out, @Nonnull String url, @Nonnull ResourceLocation def, @Nullable IImageBuffer buffer) {
        TextureManager t = Minecraft.func_71410_x().func_110434_K();
        ThreadDownloadImageData img = (ThreadDownloadImageData)t.func_110581_b(out);
        if (img == null) {
            img = new ThreadDownloadImageData(null, url, def, buffer);
            t.func_110579_a(out, (ITextureObject)img);
        }
        return img;
    }

    public static void setGLColor(int c, int a) {
        int r = LMColorUtils.getRed(c);
        int g = LMColorUtils.getGreen(c);
        int b = LMColorUtils.getBlue(c);
        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
    }

    public static void setGLColor(int c) {
        FTBLibClient.setGLColor(c, LMColorUtils.getAlpha(c));
    }

    @Nonnull
    public static ByteBuffer toByteBuffer(@Nonnull int[] pixels, boolean alpha) {
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(pixels.length * 4));
        byte alpha255 = -1;
        for (int p : pixels) {
            bb.put((byte)LMColorUtils.getRed(p));
            bb.put((byte)LMColorUtils.getGreen(p));
            bb.put((byte)LMColorUtils.getBlue(p));
            bb.put(alpha ? (byte)LMColorUtils.getAlpha(p) : alpha255);
        }
        bb.flip();
        return bb;
    }

    public static void execClientCommand(@Nonnull String s, boolean printChat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (printChat) {
            mc.field_71456_v.func_146158_b().func_146239_a(s);
        }
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)mc.field_71439_g, s) == 0) {
            mc.field_71439_g.func_71165_d(s);
        }
    }

    @Nonnull
    public static ResourceLocation getSkinTexture(@Nonnull String username) {
        ResourceLocation r = cachedSkins.get(username);
        if (r == null) {
            r = AbstractClientPlayer.func_110311_f((String)username);
            try {
                AbstractClientPlayer.func_110304_a((ResourceLocation)r, (String)username);
                cachedSkins.put(username, r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public static void setTexture(@Nonnull ResourceLocation tex) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
    }

    public static void clearCachedData() {
        cachedSkins.clear();
    }

    public static void renderItem(@Nonnull World w, @Nonnull ItemStack is) {
        if (entityItem == null) {
            entityItem = new EntityItem(w);
        }
        FTBLibClient.entityItem.field_70170_p = w;
        FTBLibClient.entityItem.field_70290_d = 0.0f;
        entityItem.func_92058_a(is);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
    }

    public static void drawOutlinedBoundingBox(@Nonnull AxisAlignedBB bb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }
}

