/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client.gui;

import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiWrapper;
import com.feed_the_beast.ftbl.api.client.gui.IClientActionGui;
import com.feed_the_beast.ftbl.api.client.gui.IGuiWrapper;
import com.feed_the_beast.ftbl.api.client.gui.widgets.PanelLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import com.feed_the_beast.ftbl.util.TextureCoords;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiLM
extends PanelLM
implements IClientActionGui {
    private static final List<String> TEMP_TEXT_LIST = new ArrayList<String>();
    public final Minecraft mc = Minecraft.func_71410_x();
    public final FontRenderer font = this.createFont(this.mc);
    public ScaledResolution screen;
    public float partialTicks;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    public int dmouseX;
    public int dmouseY;
    public int mouseWheel;
    public int dmouseWheel;
    private boolean refreshWidgets;

    public GuiLM() {
        super(0, 0, 300, 200);
    }

    public static void setupDrawing() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }

    public static void drawTexturedRect(double x, double y, double w, double h, double u0, double v0, double u1, double v1) {
        if (u0 == 0.0 && v0 == 0.0 && u1 == 0.0 && v1 == 0.0) {
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            buffer.func_181662_b(x, y + h, 0.0).func_181675_d();
            buffer.func_181662_b(x + w, y + h, 0.0).func_181675_d();
            buffer.func_181662_b(x + w, y, 0.0).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_181675_d();
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, 0.0).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, 0.0).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, 0.0).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static void drawPlayerHead(String username, double x, double y, double w, double h) {
        FTBLibClient.setTexture(FTBLibClient.getSkinTexture(username));
        GuiLM.drawTexturedRect(x, y, w, h, 0.125, 0.125, 0.25, 0.25);
        GuiLM.drawTexturedRect(x, y, w, h, 0.625, 0.125, 0.75, 0.25);
    }

    public static void drawBlankRect(double x, double y, double w, double h) {
        GlStateManager.func_179090_x();
        GuiLM.drawTexturedRect(x, y, w, h, 0.0, 0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
    }

    public static void render(TextureCoords tc, double x, double y, double w, double h) {
        if (tc != null && tc.isValid()) {
            FTBLibClient.setTexture(tc.texture);
            GuiLM.drawTexturedRect(x, y, w, h, tc.minU, tc.minV, tc.maxU, tc.maxV);
        }
    }

    public static void drawCenteredString(FontRenderer font, String txt, double x, double y, int color) {
        font.func_78276_b(txt, (int)(x - (double)font.func_78256_a(txt) / 2.0), (int)(y - (double)font.field_78288_b / 2.0), color);
    }

    public static void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static void renderGuiItem(@Nonnull RenderItem itemRender, @Nonnull ItemStack stack, double x, double y) {
        itemRender.field_77023_b = 200.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)32.0);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRender.func_180450_b(stack, 0, 0);
        itemRender.func_180453_a(font, stack, 0, 0, null);
        GlStateManager.func_179121_F();
        itemRender.field_77023_b = 0.0f;
    }

    @Nullable
    public static <E extends GuiLM> E getWrappedGui(@Nullable GuiScreen gui, @Nullable Class<E> c) {
        GuiLM g;
        if (gui == null) {
            gui = Minecraft.func_71410_x().field_71462_r;
        }
        if (gui instanceof IGuiWrapper && (g = ((IGuiWrapper)gui).getWrappedGui()) != null && (c == null || c.isAssignableFrom(g.getClass()))) {
            return (E)g;
        }
        return null;
    }

    public final void initGui() {
        this.screen = new ScaledResolution(this.mc);
        this.onInit();
        this.posX = (this.screen.func_78327_c() - this.width) / 2.0;
        this.posY = (this.screen.func_78324_d() - this.height) / 2.0;
        this.refreshWidgets();
    }

    public void onInit() {
    }

    public final void closeGui() {
        this.onClosed();
        this.mc.field_71439_g.func_71053_j();
    }

    public boolean onClosedByKey() {
        return true;
    }

    public void onClosed() {
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected FontRenderer createFont(Minecraft mc) {
        return mc.field_71466_p;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public void setFullscreen() {
        this.width = this.screen.func_78327_c();
        this.height = this.screen.func_78324_d();
        this.posY = 0.0;
        this.posX = 0.0;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.partialTicks = pt;
        this.pmouseX = this.mouseX;
        this.pmouseY = this.mouseY;
        this.mouseX = mx;
        this.mouseY = my;
        this.dmouseX = this.mouseX - this.pmouseX;
        this.dmouseY = this.mouseY - this.pmouseY;
        this.dmouseWheel = Mouse.getDWheel();
        this.mouseWheel += this.dmouseWheel;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
    }

    @Override
    public final void renderWidget(GuiLM gui) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        this.drawBackground();
        this.renderWidgets();
    }

    public void renderWidgets() {
        super.renderWidget(this);
    }

    @Override
    public boolean isInside(WidgetLM w) {
        double a = w.getAY();
        if (a < -w.height || a > this.screen.func_78324_d()) {
            return false;
        }
        a = w.getAX();
        return a >= -w.width && a <= this.screen.func_78327_c();
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawBackground() {
    }

    public void drawForeground() {
        this.addMouseOverText(this, TEMP_TEXT_LIST);
        GuiUtils.drawHoveringText(TEMP_TEXT_LIST, (int)this.mouseX, (int)Math.max(this.mouseY, 18), (int)this.screen.func_78326_a(), (int)this.screen.func_78328_b(), (int)0, (FontRenderer)this.font);
        TEMP_TEXT_LIST.clear();
    }

    public final boolean isMouseOver(WidgetLM w) {
        double ax = w.getAX();
        double ay = w.getAY();
        return (double)this.mouseX >= ax && (double)this.mouseY >= ay && (double)this.mouseX < ax + w.width && (double)this.mouseY < ay + w.height;
    }

    public GuiScreen getWrapper() {
        return new GuiWrapper(this);
    }

    public final void openGui() {
        this.mc.func_147108_a(this.getWrapper());
    }

    public final void playSoundFX(SoundEvent e, float pitch) {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)e, (float)pitch));
    }

    public final void scissor(double x, double y, double w, double h) {
        int scale = this.screen.func_78325_e();
        int h1 = this.screen.func_78328_b() * scale;
        GL11.glScissor((int)((int)(x * (double)scale)), (int)(h1 - (int)(y * (double)scale + h * (double)scale)), (int)((int)(w * (double)scale)), (int)((int)(h * (double)scale)));
    }

    @Override
    public void onClientDataChanged() {
    }
}

