/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client.gui.guibuttons;

import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.client.gui.guibuttons.ActionButton;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class ActionButtonRegistry {
    public static final ConfigGroup configGroup = new ConfigGroup();
    private static final Map<ResourceLocation, ActionButton> map = new LinkedHashMap<ResourceLocation, ActionButton>();

    public static ActionButton add(ActionButton a) {
        if (a != null) {
            map.put(a.getResourceLocation(), a);
            if (a.configDefault != null) {
                ConfigEntryBool entry = new ConfigEntryBool(a.configDefault);
                ActionButtonRegistry.configGroup.entryMap.put(a.getID(), entry);
            }
        }
        return a;
    }

    public static boolean enabled(ResourceLocation id) {
        ConfigEntry entry = ActionButtonRegistry.configGroup.entryMap.get(id.toString());
        return entry == null || entry.getAsBoolean();
    }

    public static ActionButton get(ResourceLocation key) {
        return map.get(key);
    }

    public static List<ActionButton> getButtons(ForgePlayerSP player, boolean ignoreConfig, boolean sort) {
        ArrayList<ActionButton> l = new ArrayList<ActionButton>();
        for (ActionButton a : map.values()) {
            if (!a.isVisibleFor(player) || !ignoreConfig && a.configDefault != null && !ActionButtonRegistry.enabled(a.getResourceLocation())) continue;
            l.add(a);
        }
        if (sort) {
            Collections.sort(l);
        }
        return l;
    }
}

