/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client.gui.widgets;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class PanelLM
extends WidgetLM {
    public final List<WidgetLM> widgets = new ArrayList<WidgetLM>();

    public PanelLM(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public abstract void addWidgets();

    public void add(WidgetLM w) {
        if (w != null) {
            w.parentPanel = this;
            this.widgets.add(w);
            if (w instanceof PanelLM) {
                ((PanelLM)w).refreshWidgets();
            }
        }
    }

    public void addAll(Iterable<? extends WidgetLM> l) {
        if (l != null) {
            for (WidgetLM widgetLM : l) {
                this.add(widgetLM);
            }
        }
    }

    public void refreshWidgets() {
        this.widgets.clear();
        this.addWidgets();
    }

    @Override
    public void addMouseOverText(GuiLM gui, List<String> l) {
        if (this.title != null) {
            l.add(this.title);
        }
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled() || !gui.isMouseOver(w)) continue;
            w.addMouseOverText(gui, l);
        }
    }

    @Override
    public void mousePressed(GuiLM gui, MouseButton b) {
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled()) continue;
            w.mousePressed(gui, b);
        }
    }

    @Override
    public boolean keyPressed(GuiLM gui, int key, char keyChar) {
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled() || !w.keyPressed(gui, key, keyChar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget(GuiLM gui) {
        for (WidgetLM widget : this.widgets) {
            if (!widget.shouldRender(gui)) continue;
            widget.renderWidget(gui);
        }
    }

    public boolean isInside(WidgetLM w) {
        double a0 = this.getAY();
        double a1 = w.getAY();
        if (a1 + w.height >= a0 || a1 <= a0 + this.height) {
            return true;
        }
        a0 = this.getAX();
        a1 = w.getAX();
        return a1 + w.width < a0 && a1 > a0 + this.width;
    }
}

