/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client.gui.widgets;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import com.feed_the_beast.ftbl.util.TextureCoords;
import com.latmod.lib.math.MathHelperLM;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class SliderLM
extends WidgetLM {
    public final double sliderSize;
    public boolean isGrabbed;
    public double value;
    public int displayMin = 0;
    public int displayMax = 0;
    public boolean isVertical = false;
    public double scrollStep = 0.1;

    public SliderLM(double x, double y, double w, double h, double ss) {
        super(x, y, w, h);
        this.sliderSize = ss;
    }

    public void update(GuiLM gui) {
        double v0 = this.value;
        if (this.isGrabbed) {
            if (Mouse.isButtonDown((int)0)) {
                this.value = this.isVertical ? ((double)gui.mouseY - (this.getAY() + this.sliderSize / 2.0)) / (this.height - this.sliderSize) : ((double)gui.mouseX - (this.getAX() + this.sliderSize / 2.0)) / (this.width - this.sliderSize);
            } else {
                this.isGrabbed = false;
                this.onReleased(gui);
            }
        }
        if (gui.dmouseWheel != 0 && this.canMouseScroll(gui)) {
            this.value += gui.dmouseWheel < 0 ? this.scrollStep : -this.scrollStep;
        }
        this.value = MathHelperLM.clamp(this.value, 0.0, 1.0);
        if (v0 != this.value) {
            this.onMoved(gui);
        }
    }

    public void onMoved(GuiLM gui) {
    }

    public void onReleased(GuiLM gui) {
    }

    public boolean canMouseScroll(GuiLM gui) {
        return gui.isMouseOver(this);
    }

    public int getValueI() {
        return (int)(this.value * ((this.isVertical ? this.height : this.width) - this.sliderSize));
    }

    public void renderSlider(TextureCoords tc) {
        if (this.isVertical) {
            GuiLM.render(tc, this.getAX(), this.getAY() + (double)this.getValueI(), this.width, this.sliderSize);
        } else {
            GuiLM.render(tc, this.getAX() + (double)this.getValueI(), this.getAY(), this.sliderSize, this.height);
        }
    }

    @Override
    public void mousePressed(GuiLM gui, MouseButton b) {
        if (b.isLeft() && gui.isMouseOver(this)) {
            this.isGrabbed = true;
        }
    }

    @Override
    public void addMouseOverText(GuiLM gui, List<String> l) {
        if (this.displayMin == 0 && this.displayMax == 0) {
            return;
        }
        String s = "" + (int)MathHelperLM.map(this.value, 0.0, 1.0, this.displayMin, this.displayMax);
        if (this.title != null) {
            s = this.title + ": " + s;
        }
        l.add(s);
    }
}

