/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.client.gui.widgets;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class TextBoxLM
extends WidgetLM {
    public boolean isSelected = false;
    public int charLimit = -1;
    public double textRenderX = 4.0;
    public double textRenderY = 4.0;
    public int textColor = -1;
    private String text = this.getText();

    public TextBoxLM(double x, double y, double w, double h) {
        super(x, y, w, h);
    }

    @Override
    public void mousePressed(GuiLM gui, MouseButton b) {
        if (this.charLimit == 0) {
            return;
        }
        if (gui.isMouseOver(this)) {
            this.isSelected = true;
            Keyboard.enableRepeatEvents((boolean)true);
            if (b.isRight() && this.getText().length() > 0) {
                this.clear();
                this.textChanged();
            }
        } else {
            Keyboard.enableRepeatEvents((boolean)false);
            this.isSelected = false;
        }
    }

    @Override
    public boolean keyPressed(GuiLM gui, int key, char keyChar) {
        if (this.charLimit == 0) {
            return false;
        }
        if (this.isSelected) {
            if (key == 14) {
                this.text = this.getText();
                if (this.text.length() > 0) {
                    if (GuiScreen.func_146271_m()) {
                        this.clear();
                    } else {
                        this.setText(this.text.substring(0, this.text.length() - 1));
                    }
                    this.textChanged();
                }
            } else if (key == 1) {
                this.isSelected = false;
            } else if (key == 15) {
                if (this.isValid()) {
                    this.tabPressed();
                    this.isSelected = false;
                }
            } else if (key == 28) {
                if (this.isValid()) {
                    this.returnPressed();
                    this.isSelected = false;
                }
            } else {
                this.text = this.getText();
                if ((this.charLimit == -1 || this.text.length() + 1 <= this.charLimit) && ChatAllowedCharacters.func_71566_a((char)keyChar)) {
                    this.setText(this.text + keyChar);
                    this.textChanged();
                }
            }
            return true;
        }
        return false;
    }

    public void textChanged() {
    }

    public void tabPressed() {
    }

    public void returnPressed() {
    }

    public void clear() {
        this.setText("");
    }

    public String getText() {
        return this.text;
    }

    public void setText(String s) {
        this.text = s == null ? "" : s;
    }

    @Override
    public void renderWidget(GuiLM gui) {
        String s;
        String ns = s = this.getText();
        if (this.isSelected && Minecraft.func_71386_F() % 1000L > 500L) {
            ns = ns + '_';
        }
        if (ns.length() > 0) {
            int col = this.textColor;
            if (!this.isValid()) {
                col = -65536;
            }
            if (this.textRenderX == -1.0) {
                gui.font.func_78276_b(ns, (int)(this.getAX() + this.textRenderX - (double)gui.font.func_78256_a(s) / 2.0 + this.width / 2.0), (int)(this.getAY() + this.textRenderY), col);
            } else {
                gui.font.func_78276_b(ns, (int)(this.getAX() + this.textRenderX), (int)(this.getAY() + this.textRenderY), col);
            }
        }
    }

    public boolean isValid() {
        return true;
    }
}

