/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.cmd;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.api.cmd.CommandLM;
import com.feed_the_beast.ftbl.api.cmd.ICustomCommandInfo;
import com.latmod.lib.util.LMStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandSubBase
extends CommandLM
implements ICustomCommandInfo {
    public final Map<String, ICommand> subCommands = new HashMap<String, ICommand>();

    public CommandSubBase(String s) {
        super(s);
    }

    public void add(ICommand c) {
        this.subCommands.put(c.func_71517_b(), c);
    }

    @Override
    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender ics) {
        return '/' + this.commandName + " [subcommand]";
    }

    @Override
    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> keys = new ArrayList<String>();
            for (ICommand c : this.subCommands.values()) {
                if (!c.func_184882_a(server, sender)) continue;
                keys.add(c.func_71517_b());
            }
            Collections.sort(keys, null);
            return CommandSubBase.func_175762_a((String[])args, keys);
        }
        ICommand cmd = this.subCommands.get(args[0]);
        if (cmd != null) {
            return cmd.func_184883_a(server, sender, LMStringUtils.shiftArray(args), pos);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    @Override
    public boolean func_82358_a(String[] args, int i) {
        ICommand cmd;
        if (i > 0 && args.length > 1 && (cmd = this.subCommands.get(args[0])) != null) {
            return cmd.func_82358_a(LMStringUtils.shiftArray(args), i - 1);
        }
        return false;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
        if (args.length < 1) {
            throw FTBLibLang.raw.commandError(LMStringUtils.strip(this.subCommands.keySet()));
        }
        ICommand cmd = this.subCommands.get(args[0]);
        if (cmd == null) {
            throw FTBLibLang.invalid_subcmd.commandError(args[0]);
        }
        if (!cmd.func_184882_a(server, ics)) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        cmd.func_184881_a(server, ics, LMStringUtils.shiftArray(args));
    }

    @Override
    public void addInfo(MinecraftServer server, ICommandSender sender, List<ITextComponent> list) {
        list.add((ITextComponent)new TextComponentString('/' + this.commandName));
        list.add(null);
        this.addCommandUsage(server, sender, list, 0);
    }

    private void addCommandUsage(MinecraftServer server, ICommandSender sender, List<ITextComponent> list, int level) {
        for (ICommand c : this.subCommands.values()) {
            if (c instanceof CommandSubBase) {
                list.add(this.tree((ITextComponent)new TextComponentString('/' + c.func_71517_b()), level));
                ((CommandSubBase)c).addCommandUsage(server, sender, list, level + 1);
                continue;
            }
            String usage = c.func_71518_a(sender);
            if (usage.indexOf(47) != -1 || usage.indexOf(37) != -1) {
                list.add(this.tree((ITextComponent)new TextComponentString(usage), level));
                continue;
            }
            list.add(this.tree((ITextComponent)new TextComponentTranslation(usage, new Object[0]), level));
        }
    }

    private ITextComponent tree(ITextComponent sibling, int level) {
        if (level == 0) {
            return sibling;
        }
        char[] chars = new char[level * 2];
        Arrays.fill(chars, ' ');
        return new TextComponentString(new String(chars)).func_150257_a(sibling);
    }
}

