/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.google.gson.JsonElement;
import com.latmod.lib.annotations.IFlagContainer;
import com.latmod.lib.annotations.IInfoContainer;
import com.latmod.lib.io.Bits;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;

public abstract class ConfigEntry
implements IInfoContainer,
IFlagContainer,
IJsonSerializable,
BooleanSupplier,
IntSupplier,
DoubleSupplier {
    private int flags;
    private String[] info;
    private ITextComponent displayName;

    ConfigEntry() {
    }

    public abstract ConfigEntryType getConfigType();

    public abstract void func_152753_a(@Nonnull JsonElement var1);

    @Nonnull
    public abstract JsonElement func_151003_a();

    public int getColor() {
        return 0x999999;
    }

    public String getDefValueString() {
        return null;
    }

    public String getMinValueString() {
        return null;
    }

    public String getMaxValueString() {
        return null;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(ITextComponent c) {
        this.displayName = c;
    }

    public abstract ConfigEntry copy();

    public final String toString() {
        return this.getAsString();
    }

    public abstract String getAsString();

    @Override
    public boolean getAsBoolean() {
        return false;
    }

    @Override
    public int getAsInt() {
        return 0;
    }

    @Override
    public double getAsDouble() {
        return 0.0;
    }

    public TIntList getAsIntList() {
        return TIntArrayList.wrap((int[])new int[]{this.getAsInt()});
    }

    public List<String> getAsStringList() {
        return Collections.singletonList(this.getAsString());
    }

    public ConfigGroup getAsGroup() {
        return null;
    }

    @Override
    public final int getFlags() {
        return this.flags;
    }

    @Override
    public final void setFlags(int f) {
        this.flags = f;
    }

    @Override
    public final String[] getInfo() {
        return this.info;
    }

    @Override
    public final void setInfo(String[] s) {
        this.info = s != null && s.length > 0 ? s : null;
    }

    public void writeData(ByteBuf io, boolean extended) {
        if (extended) {
            this.flags = this.getFlags();
            if (this.displayName != null) {
                this.flags = Bits.setFlag(this.flags, 512, true);
            }
            if (this.info != null && this.info.length > 0) {
                this.flags = Bits.setFlag(this.flags, 1024, true);
            }
            io.writeShort(this.flags);
            if (this.displayName != null) {
                MessageLM.writeJsonElement(io, JsonHelper.serializeICC(this.displayName));
            }
            if (this.info != null && this.info.length > 0) {
                io.writeShort(this.info.length);
                for (String s : this.info) {
                    MessageLM.writeString(io, s);
                }
            }
        }
    }

    public void readData(ByteBuf io, boolean extended) {
        if (extended) {
            this.flags = io.readUnsignedShort();
            this.setFlags(this.flags & 0xFF);
            this.displayName = null;
            this.info = null;
            if (Bits.getFlag(this.flags, 512)) {
                this.displayName = JsonHelper.deserializeICC(MessageLM.readJsonElement(io));
            }
            if (Bits.getFlag(this.flags, 1024)) {
                int s = io.readUnsignedByte();
                this.info = new String[s];
                for (int i = 0; i < s; ++i) {
                    this.info[i] = MessageLM.readString(io);
                }
            }
        }
    }

    public List<String> getVariants() {
        return null;
    }
}

