/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.IClickable;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class ConfigEntryBool
extends ConfigEntry
implements IClickable {
    public boolean defValue;
    private boolean value;

    public ConfigEntryBool(boolean def) {
        this.defValue = def;
        this.value = def;
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.BOOLEAN;
    }

    @Override
    public int getColor() {
        return this.getAsBoolean() ? 0x33AA33 : 13969460;
    }

    public void set(boolean v) {
        this.value = v;
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement o) {
        this.set(o.getAsBoolean());
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        return new JsonPrimitive(Boolean.valueOf(this.getAsBoolean()));
    }

    @Override
    public void onClicked(@Nonnull MouseButton button) {
        this.set(!this.getAsBoolean());
    }

    @Override
    public String getAsString() {
        return this.getAsBoolean() ? "true" : "false";
    }

    @Override
    public boolean getAsBoolean() {
        return this.value;
    }

    @Override
    public int getAsInt() {
        return this.getAsBoolean() ? 1 : 0;
    }

    @Override
    public double getAsDouble() {
        return this.getAsBoolean() ? 1.0 : 0.0;
    }

    @Override
    public String getDefValueString() {
        return this.defValue ? "true" : "false";
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryBool entry = new ConfigEntryBool(this.defValue);
        entry.set(this.getAsBoolean());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        io.writeBoolean(this.getAsBoolean());
        if (extended) {
            io.writeBoolean(this.defValue);
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.set(io.readBoolean());
        if (extended) {
            this.defValue = io.readBoolean();
        }
    }

    @Override
    public List<String> getVariants() {
        return Arrays.asList("true", "false");
    }
}

