/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.annotations.INumberBoundsContainer;
import com.latmod.lib.math.MathHelperLM;
import com.latmod.lib.util.LMStringUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;

public class ConfigEntryDouble
extends ConfigEntry
implements INumberBoundsContainer {
    public double defValue;
    private double value;
    private Double minValue;
    private Double maxValue;

    public ConfigEntryDouble(double d) {
        this.defValue = d;
        this.set(d);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.DOUBLE;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Double.valueOf(min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Double.valueOf(max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue;
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue;
    }

    public void set(double v) {
        this.value = MathHelperLM.clamp(v, this.getMin(), this.getMax());
    }

    public void add(double v) {
        this.set(this.getAsDouble() + v);
    }

    @Override
    public final void func_152753_a(@Nonnull JsonElement o) {
        this.set(o.getAsDouble());
    }

    @Override
    @Nonnull
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getAsDouble());
    }

    @Override
    public String getAsString() {
        return Double.toString(this.getAsDouble());
    }

    @Override
    public int getAsInt() {
        return (int)this.getAsDouble();
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return Double.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryDouble entry = new ConfigEntryDouble(this.defValue);
        entry.set(this.getAsDouble());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        io.writeDouble(this.getAsDouble());
        if (extended) {
            io.writeDouble(this.defValue);
            io.writeDouble(this.getMin());
            io.writeDouble(this.getMax());
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.set(io.readDouble());
        if (extended) {
            this.defValue = io.readDouble();
            double min = io.readDouble();
            double max = io.readDouble();
            this.setBounds(min, max);
        }
    }
}

