/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.IClickable;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.config.EnumNameMap;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class ConfigEntryEnum<E extends Enum<E>>
extends ConfigEntry
implements IClickable {
    public final int defValue;
    public final EnumNameMap<E> nameMap;
    private int index;

    public ConfigEntryEnum(E def, EnumNameMap<E> map) {
        this.nameMap = map;
        this.index = this.defValue = this.nameMap.getIndex(def);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.ENUM;
    }

    @Override
    public int getColor() {
        return 38143;
    }

    public void set(Object o) {
        this.index = this.nameMap.getIndex(o);
    }

    public E get() {
        return this.nameMap.getFromIndex(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
        if (this.index < 0 || this.index >= this.nameMap.size) {
            throw new ArrayIndexOutOfBoundsException(this.index);
        }
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement o) {
        this.set(this.nameMap.get(o.getAsString()));
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        return new JsonPrimitive(EnumNameMap.getEnumName(this.get()));
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryEnum<E> entry = new ConfigEntryEnum<E>(this.nameMap.getFromIndex(this.getIndex()), this.nameMap);
        entry.setIndex(this.getIndex());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        if (extended) {
            io.writeByte(this.nameMap.size);
            for (int i = 0; i < this.nameMap.size; ++i) {
                for (Enum e : this.nameMap.getValues()) {
                    MessageLM.writeString(io, EnumNameMap.getEnumName(e));
                }
            }
            io.writeShort(this.defValue);
        }
        MessageLM.writeString(io, EnumNameMap.getEnumName(this.get()));
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.index = this.nameMap.getStringIndex(MessageLM.readString(io));
    }

    @Override
    public void onClicked(@Nonnull MouseButton button) {
        if (button.isLeft()) {
            this.index = (this.index + 1) % this.nameMap.size;
        } else if (--this.index < 0) {
            this.index = this.nameMap.size - 1;
        }
    }

    @Override
    public String getAsString() {
        return EnumNameMap.getEnumName(this.get());
    }

    @Override
    public boolean getAsBoolean() {
        return this.get() != null;
    }

    @Override
    public int getAsInt() {
        return this.getIndex();
    }

    @Override
    public String getDefValueString() {
        return EnumNameMap.getEnumName(this.nameMap.getFromIndex(this.defValue));
    }

    public boolean isDefault() {
        return this.index == this.defValue;
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> list = new ArrayList<String>(this.nameMap.size);
        list.addAll(this.nameMap.getKeys());
        return list;
    }
}

