/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.annotations.INumberBoundsContainer;
import com.latmod.lib.math.MathHelperLM;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;

public class ConfigEntryInt
extends ConfigEntry
implements INumberBoundsContainer {
    public int defValue;
    private int value;
    private Integer minValue;
    private Integer maxValue;

    public ConfigEntryInt(int def) {
        this.defValue = def;
        this.set(def);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.INT;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Integer.valueOf((int)min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Integer.valueOf((int)max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue.doubleValue();
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue.doubleValue();
    }

    public void set(int v) {
        this.value = MathHelperLM.clampInt(v, (int)this.getMin(), (int)this.getMax());
    }

    public void add(int i) {
        this.set(this.getAsInt() + i);
    }

    @Override
    public final void func_152753_a(@Nonnull JsonElement o) {
        this.set(o == null || o.isJsonNull() ? this.defValue : o.getAsInt());
    }

    @Override
    @Nonnull
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getAsInt());
    }

    @Override
    public String getAsString() {
        return Integer.toString(this.getAsInt());
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsInt() != 0;
    }

    @Override
    public int getAsInt() {
        return this.value;
    }

    @Override
    public double getAsDouble() {
        return this.getAsInt();
    }

    @Override
    public String getDefValueString() {
        return Integer.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryInt entry = new ConfigEntryInt(this.defValue);
        entry.set(this.getAsInt());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        io.writeInt(this.getAsInt());
        if (extended) {
            io.writeInt(this.defValue);
            io.writeDouble(this.getMin());
            io.writeDouble(this.getMax());
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.set(io.readInt());
        if (extended) {
            this.defValue = io.readInt();
            double min = io.readDouble();
            double max = io.readDouble();
            this.setBounds(min, max);
        }
    }
}

