/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ConfigEntryIntList
extends ConfigEntry {
    public final TIntList defValue;
    private TIntList value;

    public ConfigEntryIntList(TIntList def) {
        this.defValue = def == null ? new TIntArrayList() : def;
        this.value = new TIntArrayList();
        this.value.addAll((TIntCollection)this.defValue);
    }

    public ConfigEntryIntList(int[] def) {
        this((TIntList)TIntArrayList.wrap((int[])def));
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.INT_ARRAY;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    public void set(TIntList l) {
        this.value.clear();
        if (l != null && !l.isEmpty()) {
            this.value.addAll((TIntCollection)l);
        }
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        TIntArrayList l = new TIntArrayList(a.size());
        for (int i = 0; i < l.size(); ++i) {
            l.set(i, a.get(i).getAsInt());
        }
        this.set((TIntList)l);
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        this.value = this.getAsIntList();
        for (int i = 0; i < this.value.size(); ++i) {
            a.add((JsonElement)new JsonPrimitive((Number)this.value.get(i)));
        }
        return a;
    }

    @Override
    public String getAsString() {
        return this.getAsIntList().toString();
    }

    @Override
    public List<String> getAsStringList() {
        TIntList list = this.getAsIntList();
        ArrayList<String> l = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            l.add(Integer.toString(list.get(i)));
        }
        return l;
    }

    @Override
    public TIntList getAsIntList() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryIntList entry = new ConfigEntryIntList(this.defValue);
        entry.set(this.getAsIntList());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        int i;
        super.writeData(io, extended);
        TIntList list = this.getAsIntList();
        int s = list.size();
        io.writeInt(s);
        for (i = 0; i < s; ++i) {
            io.writeInt(list.get(i));
        }
        if (extended) {
            s = this.defValue.size();
            io.writeInt(s);
            for (i = 0; i < s; ++i) {
                io.writeInt(this.defValue.get(i));
            }
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        int s = io.readInt();
        if (s == 0) {
            this.set(null);
        } else {
            TIntArrayList list = new TIntArrayList(s);
            for (int i = 0; i < s; ++i) {
                list.add(io.readInt());
            }
            this.set((TIntList)list);
        }
        if (extended) {
            this.defValue.clear();
            s = io.readInt();
            if (s > 0) {
                for (int i = 0; i < s; ++i) {
                    this.defValue.add(io.readInt());
                }
            }
        }
    }
}

