/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;

public class ConfigEntryString
extends ConfigEntry {
    public String defValue;
    private String value;

    public ConfigEntryString(String def) {
        this.set(def);
        this.defValue = def == null ? "" : def;
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.STRING;
    }

    @Override
    public int getColor() {
        return 16755273;
    }

    public void set(String v) {
        this.value = v == null ? "" : v;
    }

    @Override
    public final void func_152753_a(@Nonnull JsonElement o) {
        this.set(o.getAsString());
    }

    @Override
    @Nonnull
    public final JsonElement func_151003_a() {
        return new JsonPrimitive(this.getAsString());
    }

    @Override
    public String getAsString() {
        return this.value;
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsString().equals("true");
    }

    @Override
    public int getAsInt() {
        return Integer.parseInt(this.getAsString());
    }

    @Override
    public double getAsDouble() {
        return Double.parseDouble(this.getAsString());
    }

    @Override
    public String getDefValueString() {
        return this.defValue;
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryString entry = new ConfigEntryString(this.defValue);
        entry.set(this.getAsString());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        MessageLM.writeString(io, this.getAsString());
        if (extended) {
            MessageLM.writeString(io, this.defValue);
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.set(MessageLM.readString(io));
        if (extended) {
            this.defValue = MessageLM.readString(io);
        }
    }
}

