/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.IClickable;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public final class ConfigEntryStringEnum
extends ConfigEntry
implements IClickable {
    private final List<String> array = new ArrayList<String>();
    private int index;
    private int defValue;

    public ConfigEntryStringEnum() {
    }

    public ConfigEntryStringEnum(Collection<String> vals, String def) {
        this.array.addAll(vals);
        this.index = this.defValue = this.array.indexOf(def);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.ENUM;
    }

    @Override
    public int getColor() {
        return 38143;
    }

    public void set(String s) {
        this.index = this.array.indexOf(s);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx % this.array.size();
        if (this.index < 0) {
            this.index = this.array.size() - 1;
        }
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement o) {
        this.set(o.getAsString());
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getAsString());
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryStringEnum entry = new ConfigEntryStringEnum(this.array, this.array.get(this.defValue));
        entry.setIndex(this.getIndex());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        if (extended) {
            io.writeShort(this.array.size());
            if (!this.array.isEmpty()) {
                for (String s : this.array) {
                    MessageLM.writeString(io, s);
                }
            }
            io.writeShort(this.defValue);
        }
        MessageLM.writeString(io, this.getAsString());
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        if (extended) {
            this.array.clear();
            int s = io.readUnsignedShort();
            for (int i = 0; i < s; ++i) {
                this.array.add(MessageLM.readString(io));
            }
            this.defValue = io.readShort();
        }
        this.set(MessageLM.readString(io));
    }

    @Override
    public void onClicked(@Nonnull MouseButton button) {
        if (button.isLeft()) {
            this.setIndex(this.getIndex() + 1);
        } else {
            this.setIndex(this.getIndex() - 1);
        }
    }

    @Override
    public String getAsString() {
        return this.array.get(this.index);
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsString() != null;
    }

    @Override
    public int getAsInt() {
        return this.index;
    }

    @Override
    public String getDefValueString() {
        return this.array.get(this.defValue);
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> list = new ArrayList<String>(this.array.size());
        list.addAll(this.array);
        return list;
    }
}

