/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.util.LMListUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ConfigEntryStringList
extends ConfigEntry {
    public final List<String> defValue;
    private List<String> value = new ArrayList<String>();

    public ConfigEntryStringList(List<String> def) {
        this.defValue = new ArrayList<String>();
        if (def != null && !def.isEmpty()) {
            this.defValue.addAll(def);
            this.value.addAll(def);
        }
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.STRING_ARRAY;
    }

    @Override
    public int getColor() {
        return 16755273;
    }

    public void set(List<String> o) {
        this.value.clear();
        if (o != null && !o.isEmpty()) {
            this.value.addAll(o);
        }
    }

    @Override
    public final void func_152753_a(@Nonnull JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        this.value.clear();
        for (int i = 0; i < a.size(); ++i) {
            this.value.add(a.get(i).getAsString());
        }
        this.set(LMListUtils.clone(this.value));
    }

    @Override
    @Nonnull
    public final JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        for (String aValue : this.getAsStringList()) {
            a.add((JsonElement)new JsonPrimitive(aValue));
        }
        return a;
    }

    @Override
    public String getAsString() {
        return this.getAsStringList().toString();
    }

    @Override
    public boolean getAsBoolean() {
        return !this.getAsStringList().isEmpty();
    }

    @Override
    public TIntList getAsIntList() {
        List<String> list = this.getAsStringList();
        TIntArrayList l = new TIntArrayList(list.size());
        for (String s : this.getAsStringList()) {
            l.add(Integer.parseInt(s));
        }
        return l;
    }

    @Override
    public List<String> getAsStringList() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }

    @Override
    public ConfigEntry copy() {
        ConfigEntryStringList entry = new ConfigEntryStringList(this.defValue);
        entry.set(this.getAsStringList());
        return entry;
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        int i;
        super.writeData(io, extended);
        List<String> list = this.getAsStringList();
        int s = list.size();
        io.writeInt(s);
        for (i = 0; i < s; ++i) {
            MessageLM.writeString(io, list.get(i));
        }
        if (extended) {
            s = this.defValue.size();
            io.writeInt(s);
            for (i = 0; i < s; ++i) {
                MessageLM.writeString(io, this.defValue.get(i));
            }
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        int s = io.readInt();
        if (s == 0) {
            this.set(null);
        } else {
            ArrayList<String> list = new ArrayList<String>(s);
            for (int i = 0; i < s; ++i) {
                list.add(MessageLM.readString(io));
            }
            this.set(list);
        }
        if (extended) {
            this.defValue.clear();
            s = io.readInt();
            if (s > 0) {
                for (int i = 0; i < s; ++i) {
                    this.defValue.add(MessageLM.readString(io));
                }
            }
        }
    }
}

