/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.api.config.ConfigEntryColor;
import com.feed_the_beast.ftbl.api.config.ConfigEntryCustom;
import com.feed_the_beast.ftbl.api.config.ConfigEntryDouble;
import com.feed_the_beast.ftbl.api.config.ConfigEntryInt;
import com.feed_the_beast.ftbl.api.config.ConfigEntryIntList;
import com.feed_the_beast.ftbl.api.config.ConfigEntryString;
import com.feed_the_beast.ftbl.api.config.ConfigEntryStringEnum;
import com.feed_the_beast.ftbl.api.config.ConfigEntryStringList;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.latmod.lib.LMColor;
import gnu.trove.list.TIntList;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;

public enum ConfigEntryType {
    CUSTOM(1),
    GROUP(2),
    BOOLEAN(3),
    INT(4),
    DOUBLE(5),
    STRING(6),
    ENUM(7),
    INT_ARRAY(8),
    STRING_ARRAY(9),
    COLOR(10);

    private static final TByteObjectMap<ConfigEntryType> TYPE_MAP;
    public final byte ID;

    private ConfigEntryType(int i) {
        this.ID = (byte)i;
    }

    public static ConfigEntryType getFromID(byte id) {
        return (ConfigEntryType)((Object)TYPE_MAP.get(id));
    }

    public ConfigEntry createNew() {
        switch (this) {
            case CUSTOM: {
                return new ConfigEntryCustom();
            }
            case GROUP: {
                return new ConfigGroup();
            }
            case BOOLEAN: {
                return new ConfigEntryBool(false);
            }
            case INT: {
                return new ConfigEntryInt(0);
            }
            case DOUBLE: {
                return new ConfigEntryDouble(0.0);
            }
            case STRING: {
                return new ConfigEntryString(null);
            }
            case ENUM: {
                return new ConfigEntryStringEnum();
            }
            case INT_ARRAY: {
                return new ConfigEntryIntList((TIntList)null);
            }
            case STRING_ARRAY: {
                return new ConfigEntryStringList(null);
            }
            case COLOR: {
                return new ConfigEntryColor(new LMColor.RGB());
            }
        }
        return null;
    }

    static {
        TYPE_MAP = new TByteObjectHashMap();
        for (ConfigEntryType t : ConfigEntryType.values()) {
            TYPE_MAP.put(t.ID, (Object)t);
        }
    }
}

