/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryCustom;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.config.ConfigFile;
import com.feed_the_beast.ftbl.api.net.MessageLM;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.lib.annotations.AnnotationHelper;
import com.latmod.lib.annotations.ID;
import com.latmod.lib.util.LMUtils;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConfigGroup
extends ConfigEntry {
    public final LinkedHashMap<String, ConfigEntry> entryMap = this.createEntryMap();

    private static boolean isValidChar(char c) {
        switch (c) {
            case '_': {
                return true;
            }
            case ':': {
                return true;
            }
        }
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    protected LinkedHashMap<String, ConfigEntry> createEntryMap() {
        return new LinkedHashMap<String, ConfigEntry>();
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.GROUP;
    }

    public ConfigEntry getEntryFromFullID(String id) {
        int idx = id.indexOf(46);
        if (idx == -1) {
            return this.entryMap.get(id);
        }
        ConfigEntry group = this.entryMap.get(id.substring(0, idx));
        if (group != null && group.getAsGroup() != null) {
            return group.getAsGroup().getEntryFromFullID(id.substring(idx + 1));
        }
        return null;
    }

    public ConfigFile asConfigFile() {
        return null;
    }

    public ConfigGroup add(String s, ConfigEntry e) {
        for (int i = 0; i < s.length(); ++i) {
            if (ConfigGroup.isValidChar(s.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid ID: " + s + " - it can only contain '_', ':', 'a'-'z' and '0'-'9'!");
        }
        if (e != null) {
            this.entryMap.put(s, e);
        }
        return this;
    }

    public ConfigGroup addAll(Class<?> c, Object parent) {
        try {
            Field[] f = c.getDeclaredFields();
            if (f != null && f.length > 0) {
                for (Field aF : f) {
                    try {
                        aF.setAccessible(true);
                        if (!ConfigEntry.class.isAssignableFrom(aF.getType())) continue;
                        String id = aF.isAnnotationPresent(ID.class) ? aF.getDeclaredAnnotation(ID.class).value() : aF.getName();
                        ConfigEntry entry = (ConfigEntry)aF.get(parent);
                        if (entry == null || entry == this || entry instanceof ConfigFile) continue;
                        AnnotationHelper.inject(aF, entry);
                        this.add(id, entry);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public ConfigEntry copy() {
        ConfigGroup g = new ConfigGroup();
        for (Map.Entry<String, ConfigEntry> entry : this.entryMap.entrySet()) {
            g.add(entry.getKey(), entry.getValue().copy());
        }
        return g;
    }

    @Override
    public final void func_152753_a(@Nonnull JsonElement o0) {
        this.entryMap.clear();
        if (o0.isJsonObject()) {
            JsonObject o = o0.getAsJsonObject();
            for (Map.Entry e : o.entrySet()) {
                ConfigEntryCustom entry = new ConfigEntryCustom();
                if (!((JsonElement)e.getValue()).isJsonNull()) {
                    ((ConfigEntry)entry).func_152753_a((JsonElement)e.getValue());
                }
                this.add((String)e.getKey(), entry);
            }
        }
    }

    @Override
    @Nonnull
    public final JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        for (Map.Entry<String, ConfigEntry> entry : this.entryMap.entrySet()) {
            if ((entry.getValue().getFlags() & 0x10) != 0) continue;
            o.add(entry.getKey(), entry.getValue().func_151003_a());
        }
        return o;
    }

    @Override
    public String getAsString() {
        return this.func_151003_a().toString();
    }

    @Override
    public List<String> getAsStringList() {
        ArrayList<String> list = new ArrayList<String>(this.entryMap.size());
        for (ConfigEntry e : this.entryMap.values()) {
            list.add(e.getAsString());
        }
        return list;
    }

    @Override
    public boolean getAsBoolean() {
        return !this.entryMap.isEmpty();
    }

    @Override
    public int getAsInt() {
        return this.entryMap.size();
    }

    @Override
    public void writeData(ByteBuf io, boolean extended) {
        super.writeData(io, extended);
        io.writeShort(this.entryMap.size());
        if (!this.entryMap.isEmpty()) {
            for (Map.Entry<String, ConfigEntry> entry : this.entryMap.entrySet()) {
                io.writeByte((int)entry.getValue().getConfigType().ID);
                MessageLM.writeString(io, entry.getKey());
                entry.getValue().writeData(io, extended);
            }
        }
    }

    @Override
    public void readData(ByteBuf io, boolean extended) {
        super.readData(io, extended);
        this.entryMap.clear();
        int s = io.readUnsignedShort();
        for (int i = 0; i < s; ++i) {
            ConfigEntryType t = ConfigEntryType.getFromID(io.readByte());
            String id = MessageLM.readString(io);
            ConfigEntry entry = t.createNew();
            entry.readData(io, extended);
            this.entryMap.put(id, entry);
        }
    }

    private Map<String, JsonElement> getFullMapFromObject(Map<String, JsonElement> map, JsonObject obj, String parent) {
        for (Map.Entry entry : obj.entrySet()) {
            JsonElement e = (JsonElement)entry.getValue();
            if (e != null && e.isJsonObject()) {
                this.getFullMapFromObject(map, e.getAsJsonObject(), (String)entry.getKey());
                continue;
            }
            map.put(parent == null ? (String)entry.getKey() : parent + '.' + (String)entry.getKey(), e);
        }
        return map;
    }

    public int loadFromGroup(JsonObject json) {
        Map<String, JsonElement> map1;
        int result = 0;
        if (json != null && !(map1 = this.getFullMapFromObject(new HashMap<String, JsonElement>(), json, null)).isEmpty()) {
            for (Map.Entry<String, JsonElement> entry : map1.entrySet()) {
                ConfigEntry e0 = this.getEntryFromFullID(entry.getKey());
                if (e0 == null) continue;
                try {
                    e0.func_152753_a(entry.getValue());
                    ++result;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                    System.err.println("Can't set value " + entry.getValue().getAsString() + " for '" + entry.getKey() + "' (type:" + (Object)((Object)e0.getConfigType()) + ")");
                }
            }
        }
        this.onLoadedFromGroup(json, result);
        return result;
    }

    protected void onLoadedFromGroup(JsonObject json, int loaded) {
    }

    public boolean hasKey(Object key) {
        return this.entryMap.containsKey(LMUtils.getID(key));
    }

    public ConfigEntry getEntry(Object key) {
        return this.entryMap.get(LMUtils.getID(key));
    }

    public ConfigGroup getGroup(Object key) {
        ConfigEntry e = this.getEntry(key);
        return e == null ? null : e.getAsGroup();
    }

    public List<ConfigGroup> getGroups() {
        ArrayList<ConfigGroup> list = new ArrayList<ConfigGroup>();
        for (ConfigEntry e : this.entryMap.values()) {
            ConfigGroup g = e.getAsGroup();
            if (g == null) continue;
            list.add(g);
        }
        return list;
    }

    @Override
    public ConfigGroup getAsGroup() {
        return this;
    }

    public Map<String, ConfigEntry> getFullEntryMap() {
        return this.getFullEntryMap0(new HashMap<String, ConfigEntry>(), null);
    }

    private Map<String, ConfigEntry> getFullEntryMap0(Map<String, ConfigEntry> map, String prevID) {
        for (Map.Entry<String, ConfigEntry> e : this.entryMap.entrySet()) {
            String id = e.getKey();
            ConfigGroup vg = e.getValue().getAsGroup();
            if (vg != null) {
                vg.getFullEntryMap0(map, prevID == null ? id : prevID + '.' + id);
                continue;
            }
            if (prevID == null) {
                map.put(id, e.getValue());
                continue;
            }
            map.put(prevID + '.' + id, e.getValue());
        }
        return map;
    }
}

