/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.IStringSerializable;

public final class EnumNameMap<E extends Enum<E>> {
    private static String NULL_VALUE = "-";
    public final int size;
    private final Map<String, E> map;
    private final List<E> values;

    public EnumNameMap(boolean addNull, E[] v) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : v) {
            if (e == null) continue;
            list.add(e);
        }
        if (addNull) {
            list.add(null);
        }
        this.values = Collections.unmodifiableList(list);
        this.size = this.values.size();
        HashMap<String, Enum> map1 = new HashMap<String, Enum>(this.size);
        for (Enum e : this.values) {
            map1.put(EnumNameMap.getEnumName(e), e);
        }
        this.map = Collections.unmodifiableMap(map1);
    }

    public static String getEnumName(Enum<?> e) {
        if (e == null) {
            return NULL_VALUE;
        }
        if (e instanceof IStringSerializable) {
            return ((IStringSerializable)e).func_176610_l();
        }
        return e.name().toLowerCase(Locale.US);
    }

    public E get(String s) {
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return null;
        }
        return (E)((Enum)this.map.get(s));
    }

    public E getFromIndex(int index) {
        return (E)((Enum)this.values.get(index));
    }

    public int getIndex(Object e) {
        return this.values.indexOf(e);
    }

    public int getStringIndex(String s) {
        return this.getIndex(this.map.get(s));
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public List<E> getValues() {
        return this.values;
    }
}

