/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.info;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.api.info.InfoTextLine;
import com.feed_the_beast.ftbl.api.notification.ClickAction;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoExtendedTextLine;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoTextLine;
import com.feed_the_beast.ftbl.gui.info.GuiInfo;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfoExtendedTextLine
extends InfoTextLine {
    protected ITextComponent text;
    private ClickAction clickAction;
    private List<ITextComponent> hover;

    public InfoExtendedTextLine(InfoPage c, ITextComponent cc) {
        super(c, null);
        this.text = cc;
        if (this.text != null) {
            HoverEvent hoverEvent;
            ClickEvent clickEvent = this.text.func_150256_b().func_150235_h();
            if (clickEvent != null) {
                this.clickAction = ClickAction.from(clickEvent);
            }
            if ((hoverEvent = this.text.func_150256_b().func_150210_i()) != null && hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.hover = Collections.singletonList(hoverEvent.func_150702_b());
            }
        }
    }

    @Override
    public ITextComponent getText() {
        return this.text;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ButtonInfoTextLine createWidget(GuiInfo gui) {
        return new ButtonInfoExtendedTextLine(gui, this);
    }

    public List<ITextComponent> getHover() {
        return this.hover;
    }

    public void setHover(List<ITextComponent> h) {
        if (h == null || h.isEmpty()) {
            this.hover = null;
        } else {
            this.hover = new ArrayList<ITextComponent>(h.size());
            this.hover.addAll(h);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasClickAction() {
        return this.clickAction != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClicked(MouseButton button) {
        if (this.clickAction != null) {
            GuiLM.playClickSound();
            this.clickAction.onClicked(button);
        }
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        ITextComponent iTextComponent = this.text = o.has("text") ? JsonHelper.deserializeICC(o.get("text")) : null;
        if (o.has("click")) {
            this.clickAction = new ClickAction();
            this.clickAction.func_152753_a(o.get("click"));
        } else {
            this.clickAction = null;
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<ITextComponent>();
            JsonElement e1 = o.get("hover");
            if (e1.isJsonPrimitive()) {
                this.hover.add(JsonHelper.deserializeICC(e1));
            } else {
                for (JsonElement e2 : o.get("hover").getAsJsonArray()) {
                    this.hover.add(JsonHelper.deserializeICC(e2));
                }
            }
            if (this.hover.isEmpty()) {
                this.hover = null;
            }
        } else {
            this.hover = null;
        }
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        if (this.text != null) {
            o.add("text", JsonHelper.serializeICC(this.text));
        }
        if (this.clickAction != null) {
            o.add("click", this.clickAction.func_151003_a());
        }
        if (this.hover != null && !this.hover.isEmpty()) {
            if (this.hover.size() == 1) {
                o.add("hover", JsonHelper.serializeICC(this.hover.get(0)));
            } else {
                JsonArray a = new JsonArray();
                for (ITextComponent c : this.hover) {
                    a.add(JsonHelper.serializeICC(c));
                }
                o.add("hover", (JsonElement)a);
            }
        }
        return o;
    }

    public void setClickAction(ClickAction a) {
        this.clickAction = a;
    }
}

