/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.info;

import com.feed_the_beast.ftbl.api.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.api.info.InfoImage;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoImage;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoTextLine;
import com.feed_the_beast.ftbl.gui.info.GuiInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.util.LMUtils;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfoImageLine
extends InfoExtendedTextLine {
    public String imageURL;
    private InfoImage texture;
    private double displayW;
    private double displayH;
    private double displayS;

    public InfoImageLine(InfoPage c) {
        super(c, (ITextComponent)null);
    }

    public InfoImageLine(InfoPage c, InfoImage img) {
        this(c);
        this.texture = img;
    }

    @SideOnly(value=Side.CLIENT)
    public InfoImage getImage() {
        if (this.texture == InfoImage.NULL) {
            return null;
        }
        if (this.texture != null) {
            return this.texture;
        }
        this.texture = InfoImage.NULL;
        try {
            BufferedImage img = this.page.getResourceProvider().getConnection(this.imageURL).connect().asImage();
            ResourceLocation tex = Minecraft.func_71410_x().func_110434_K().func_110578_a("ftbu_guide/" + this.imageURL, new DynamicTexture(img));
            this.texture = new InfoImage(tex, img.getWidth(), img.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.texture;
    }

    public InfoImageLine setImage(String img) {
        String imageURL0 = this.imageURL == null ? null : this.imageURL + "";
        this.imageURL = img;
        if (!LMUtils.areObjectsEqual(imageURL0, this.imageURL, true)) {
            this.texture = null;
        }
        if (this.imageURL != null) {
            this.text = null;
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public InfoImage getDisplayImage() {
        double w;
        InfoImage img = this.getImage();
        if (img == null) {
            return null;
        }
        double d = this.displayW > 0.0 ? this.displayW : (this.displayS == 0.0 ? this.texture.width : (w = this.displayS > 0.0 ? this.texture.width * this.displayS : this.texture.width / -this.displayS));
        double h = this.displayH > 0.0 ? this.displayH : (this.displayS == 0.0 ? this.texture.height : (this.displayS > 0.0 ? this.texture.height * this.displayS : this.texture.height / -this.displayS));
        return new InfoImage(this.texture.texture, w, h);
    }

    public InfoImageLine setSize(double w, double h) {
        this.displayW = w;
        this.displayH = h;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ButtonInfoTextLine createWidget(GuiInfo gui) {
        if (this.getImage() == null) {
            return null;
        }
        return new ButtonInfoImage(gui, this);
    }

    @Override
    public void func_152753_a(@Nonnull JsonElement e) {
        super.func_152753_a(e);
        this.displayS = 0.0;
        this.displayH = 0.0;
        this.displayW = 0.0;
        JsonObject o = e.getAsJsonObject();
        this.setImage(o.has("image") ? o.get("image").getAsString() : null);
        if (o.has("scale")) {
            this.displayS = o.get("scale").getAsDouble();
        } else {
            if (o.has("width")) {
                this.displayW = o.get("width").getAsDouble();
            }
            if (o.has("height")) {
                this.displayH = o.get("height").getAsDouble();
            }
        }
    }

    @Override
    @Nonnull
    public JsonElement func_151003_a() {
        JsonObject o = (JsonObject)super.func_151003_a();
        if (this.imageURL != null && !this.imageURL.isEmpty()) {
            o.add("image", (JsonElement)new JsonPrimitive(this.imageURL));
        }
        return o;
    }
}

