/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.info;

import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.events.InfoGuiLineEvent;
import com.feed_the_beast.ftbl.api.info.IResourceProvider;
import com.feed_the_beast.ftbl.api.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.api.info.InfoImageLine;
import com.feed_the_beast.ftbl.api.info.InfoPageTheme;
import com.feed_the_beast.ftbl.api.info.InfoTextLine;
import com.feed_the_beast.ftbl.api.info.URLResourceProvider;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoPage;
import com.feed_the_beast.ftbl.gui.info.GuiInfo;
import com.feed_the_beast.ftbl.net.MessageDisplayInfo;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.latmod.lib.FinalIDObject;
import com.latmod.lib.RemoveFilter;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMMapUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfoPage
extends FinalIDObject
implements IJsonSerializable,
Comparable<InfoPage> {
    private static final RemoveFilter<Map.Entry<String, InfoPage>> CLEANUP_FILTER = entry -> ((InfoPage)entry.getValue()).childPages.isEmpty() && ((InfoPage)entry.getValue()).getUnformattedText().trim().isEmpty();
    public final List<InfoTextLine> text = new ArrayList<InfoTextLine>();
    public final LinkedHashMap<String, InfoPage> childPages = new LinkedHashMap();
    public InfoPage parent = null;
    public InfoPageTheme theme;
    public IResourceProvider resourceProvider;
    private ITextComponent title;

    public InfoPage(String id) {
        super(id);
    }

    public InfoPage setTitle(ITextComponent c) {
        this.title = c;
        return this;
    }

    public InfoPage setParent(InfoPage c) {
        this.parent = c;
        return this;
    }

    public InfoPage getOwner() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getOwner();
    }

    public InfoTextLine createLine(JsonElement e) {
        InfoExtendedTextLine l;
        if (e == null || e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            String s = e.getAsString();
            return s.trim().isEmpty() ? null : new InfoTextLine(this, s);
        }
        JsonObject o = e.getAsJsonObject();
        if (o.has("image")) {
            l = new InfoImageLine(this);
        } else {
            InfoGuiLineEvent event = new InfoGuiLineEvent(this, o);
            MinecraftForge.EVENT_BUS.post((Event)event);
            l = event.line == null ? new InfoExtendedTextLine(this, null) : event.line;
        }
        ((InfoExtendedTextLine)l).func_152753_a((JsonElement)o);
        return l;
    }

    public void println(ITextComponent c) {
        if (c == null) {
            this.text.add(null);
        } else if (c instanceof TextComponentString && c.func_150256_b().func_150229_g() && c.func_150253_a().isEmpty()) {
            this.printlnText(((TextComponentString)c).func_150265_g());
        } else {
            this.text.add(new InfoExtendedTextLine(this, c));
        }
    }

    public void printlnText(String s) {
        this.text.add(s == null || s.isEmpty() ? null : new InfoTextLine(this, s));
    }

    public String getUnformattedText() {
        if (this.text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int s = this.text.size();
        for (int i = 0; i < s; ++i) {
            InfoTextLine c = this.text.get(i);
            if (c == null || c.getText() == null) {
                sb.append('\n');
            } else {
                try {
                    sb.append(c.getText().func_150260_c());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (i == s - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public void addSub(InfoPage c) {
        this.childPages.put(c.getID(), c);
        c.setParent(this);
    }

    public ITextComponent getTitleComponent() {
        return this.title == null ? new TextComponentString(this.getID()) : this.title;
    }

    public InfoPage getSub(String id) {
        InfoPage c = this.childPages.get(id);
        if (c == null) {
            c = new InfoPage(id);
            c.setParent(this);
            this.childPages.put(id, c);
        }
        return c;
    }

    public void clear() {
        this.text.clear();
        this.childPages.clear();
    }

    public void cleanup() {
        this.childPages.values().forEach(InfoPage::cleanup);
        LMMapUtils.removeAll(this.childPages, CLEANUP_FILTER);
    }

    public void sortAll() {
        LMMapUtils.sortMap(this.childPages, (o1, o2) -> ((InfoPage)o1.getValue()).compareTo((InfoPage)o2.getValue()));
        for (InfoPage c : this.childPages.values()) {
            c.sortAll();
        }
    }

    public void copyFrom(InfoPage c) {
        for (InfoTextLine l : c.text) {
            this.text.add(l == null ? null : l.copy(this));
        }
        for (InfoPage p : c.childPages.values()) {
            InfoPage p1 = new InfoPage(p.getID());
            p1.copyFrom(p);
            this.addSub(p1);
        }
    }

    public InfoPage copy() {
        InfoPage page = new InfoPage(this.getID());
        page.func_152753_a(this.func_151003_a());
        return page;
    }

    public InfoPage getParentTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getParentTop();
    }

    @Nonnull
    public JsonElement func_151003_a() {
        JsonElement e;
        JsonObject o = new JsonObject();
        if (this.title != null) {
            o.add("N", JsonHelper.serializeICC(this.title));
        }
        if (!this.text.isEmpty()) {
            JsonArray a = new JsonArray();
            for (InfoTextLine infoTextLine : this.text) {
                a.add((JsonElement)(infoTextLine == null ? JsonNull.INSTANCE : infoTextLine.func_151003_a()));
            }
            o.add("T", (JsonElement)a);
        }
        if (!this.childPages.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (InfoPage infoPage : this.childPages.values()) {
                o1.add(infoPage.getID(), infoPage.func_151003_a());
            }
            o.add("S", (JsonElement)o1);
        }
        if (this.theme != null && (e = this.theme.func_151003_a()) != null) {
            o.add("C", e);
        }
        return o;
    }

    public void func_152753_a(@Nonnull JsonElement e) {
        this.clear();
        if (e == null || !e.isJsonObject()) {
            return;
        }
        JsonObject o = e.getAsJsonObject();
        ITextComponent iTextComponent = this.title = o.has("N") ? JsonHelper.deserializeICC(o.get("N")) : null;
        if (o.has("T")) {
            JsonArray a = o.get("T").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                this.text.add(this.createLine(a.get(i)));
            }
        }
        if (o.has("S")) {
            JsonObject o1 = o.get("S").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                InfoPage c = new InfoPage((String)entry.getKey());
                c.setParent(this);
                c.func_152753_a((JsonElement)entry.getValue());
                this.childPages.put(c.getID(), c);
            }
        }
        if (o.has("C")) {
            this.theme = new InfoPageTheme();
            this.theme.func_152753_a(o.get("C"));
        } else {
            this.theme = null;
        }
    }

    public MessageDisplayInfo displayGuide(EntityPlayerMP ep) {
        MessageDisplayInfo m = new MessageDisplayInfo(this);
        if (ep != null && !(ep instanceof FakePlayer)) {
            m.sendTo(ep);
        }
        return m;
    }

    public final InfoPageTheme getTheme() {
        return this.theme == null ? (this.parent == null ? InfoPageTheme.DEFAULT : this.parent.getTheme()) : this.theme;
    }

    public final IResourceProvider getResourceProvider() {
        return this.resourceProvider == null ? (this.parent == null ? URLResourceProvider.INSTANCE : this.parent.getResourceProvider()) : this.resourceProvider;
    }

    @SideOnly(value=Side.CLIENT)
    public final void refreshGuiTree(GuiInfo gui) {
        this.refreshGui(gui);
        for (InfoPage p : this.childPages.values()) {
            p.refreshGuiTree(gui);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void refreshGui(GuiInfo gui) {
    }

    @SideOnly(value=Side.CLIENT)
    public ButtonLM createSpecialButton(GuiInfo gui) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ButtonInfoPage createButton(GuiInfo gui) {
        return new ButtonInfoPage(gui, this, null);
    }

    public String getFullID() {
        if (this.parent == null) {
            return this.getID();
        }
        return this.parent.getFullID() + '.' + this.getID();
    }

    public String getPath() {
        if (this.parent == null) {
            return this.getID();
        }
        return this.parent.getFullID() + '/' + this.getID();
    }

    public void loadText(List<String> list) throws Exception {
        for (JsonElement e : LMJsonUtils.deserializeText(list)) {
            this.text.add(this.createLine(e));
        }
    }

    @Override
    public int compareTo(@Nonnull InfoPage o) {
        return this.getTitleComponent().func_150254_d().compareToIgnoreCase(o.getTitleComponent().func_150254_d());
    }
}

