/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.item;

import com.feed_the_beast.ftbl.api.item.LMInvUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.util.LMStringUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemStackSerializer {
    private static String getParseRegex(String s) {
        if (s.indexOf(32) != -1) {
            return " ";
        }
        if (s.indexOf(59) != -1) {
            return ";";
        }
        if (s.indexOf(64) != -1) {
            return "@";
        }
        return " x ";
    }

    public static ItemStack parseItem(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        String[] s1 = s.split(ItemStackSerializer.getParseRegex(s));
        if (s1.length == 0) {
            return null;
        }
        String itemID = s1[0];
        int dmg = 0;
        int size = 1;
        String nbt = null;
        if (s1.length > 1) {
            size = Integer.parseInt(s1[1]);
        }
        if (s1.length > 2) {
            int n = dmg = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : Integer.parseInt(s1[2]);
        }
        if (s1.length > 3) {
            nbt = LMStringUtils.unsplitSpaceUntilEnd(3, s1);
        }
        return GameRegistry.makeItemStack((String)itemID, (int)size, (int)dmg, (String)nbt);
    }

    public static String toString(ItemStack is) {
        return is == null ? null : LMInvUtils.getRegName(is).toString() + is + ' ' + is.field_77994_a + ' ' + is.func_77952_i();
    }

    public static JsonElement serialize(ItemStack is) {
        return is == null ? JsonNull.INSTANCE : new JsonPrimitive(ItemStackSerializer.toString(is));
    }

    public static ItemStack deserialize(JsonElement e) {
        if (e == null || e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)e.toString());
            return ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

