/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.net;

import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.google.gson.JsonElement;
import com.latmod.lib.io.ByteIOStream;
import com.latmod.lib.json.JsonElementIO;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class MessageLM<E extends MessageLM<E>>
implements IMessage,
IMessageHandler<E, IMessage> {
    MessageLM() {
    }

    static boolean logMessages() {
        return false;
    }

    public static UUID readUUID(ByteBuf io) {
        long msb = io.readLong();
        long lsb = io.readLong();
        return new UUID(msb, lsb);
    }

    public static void writeUUID(ByteBuf io, UUID id) {
        io.writeLong(id.getMostSignificantBits());
        io.writeLong(id.getLeastSignificantBits());
    }

    public static String readString(ByteBuf io) {
        return ByteBufUtils.readUTF8String((ByteBuf)io);
    }

    public static void writeString(ByteBuf io, String s) {
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)s);
    }

    public static ResourceLocation readResourceLocation(ByteBuf io) {
        String d = MessageLM.readString(io);
        String p = MessageLM.readString(io);
        return new ResourceLocation(d, p);
    }

    public static void writeResourceLocation(ByteBuf io, ResourceLocation r) {
        MessageLM.writeString(io, r.func_110624_b());
        MessageLM.writeString(io, r.func_110623_a());
    }

    public static NBTTagCompound readTag(ByteBuf io) {
        return ByteBufUtils.readTag((ByteBuf)io);
    }

    public static void writeTag(ByteBuf io, NBTTagCompound tag) {
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)tag);
    }

    public static JsonElement readJsonElement(ByteBuf io) {
        byte[] b = new byte[io.readInt()];
        io.readBytes(b, 0, b.length);
        ByteIOStream stream = new ByteIOStream();
        stream.setCompressedData(b);
        return JsonElementIO.read(stream);
    }

    public static void writeJsonElement(ByteBuf io, JsonElement e) {
        ByteIOStream stream = new ByteIOStream();
        JsonElementIO.write(stream, e);
        byte[] b = stream.toCompressedByteArray();
        io.writeInt(b.length);
        io.writeBytes(b, 0, b.length);
    }

    public abstract LMNetworkWrapper getWrapper();

    abstract Side getReceivingSide();

    public abstract void toBytes(ByteBuf var1);

    public abstract void fromBytes(ByteBuf var1);

    public IMessage onMessage(E m, MessageContext ctx) {
        return null;
    }
}

