/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.notification;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.notification.ClickActionRegistry;
import com.feed_the_beast.ftbl.api.notification.ClickActionType;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClickAction
implements IJsonSerializable {
    public ClickActionType type;
    public JsonElement data;

    public ClickAction() {
    }

    public ClickAction(@Nonnull ClickActionType t, @Nullable JsonElement d) {
        this.type = t;
        this.data = d == null ? JsonNull.INSTANCE : d;
    }

    public static ClickAction from(@Nonnull ClickEvent e) {
        JsonPrimitive p = new JsonPrimitive(e.func_150668_b());
        switch (e.func_150669_a()) {
            case RUN_COMMAND: {
                return new ClickAction(ClickActionType.CMD, (JsonElement)p);
            }
            case OPEN_FILE: {
                return new ClickAction(ClickActionType.FILE, (JsonElement)p);
            }
            case SUGGEST_COMMAND: {
                return new ClickAction(ClickActionType.SHOW_CMD, (JsonElement)p);
            }
            case OPEN_URL: {
                return new ClickAction(ClickActionType.URL, (JsonElement)p);
            }
            case CHANGE_PAGE: {
                return new ClickAction(ClickActionType.CHANGE_INFO_PAGE, (JsonElement)p);
            }
        }
        return null;
    }

    @Nonnull
    public JsonElement func_151003_a() {
        if (this.type == null) {
            return JsonNull.INSTANCE;
        }
        if (this.data == null || this.data.isJsonNull()) {
            return new JsonPrimitive(this.type.getID());
        }
        JsonObject o = new JsonObject();
        o.add("type", (JsonElement)new JsonPrimitive(this.type.getID()));
        o.add("data", this.data);
        return o;
    }

    public void func_152753_a(@Nonnull JsonElement e) {
        if (e.isJsonNull()) {
            this.type = null;
            this.data = null;
        } else if (e.isJsonPrimitive()) {
            this.type = ClickActionRegistry.get(e.getAsString());
            this.data = null;
        } else {
            JsonObject o = e.getAsJsonObject();
            this.type = ClickActionRegistry.get(o.get("type").getAsString());
            this.data = o.get("data");
            if (this.data == JsonNull.INSTANCE) {
                this.data = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClicked(@Nonnull MouseButton button) {
        if (this.type != null) {
            this.type.onClicked((JsonElement)(this.data == null ? JsonNull.INSTANCE : this.data), button);
        }
    }

    public String toString() {
        return this.data == null ? this.type.getID() : this.data.toString();
    }
}

