/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.notification;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.notification.Notification;
import com.latmod.lib.FinalIDObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientNotifications {
    private static Temp current = null;

    public static void renderTemp(RenderGameOverlayEvent event) {
        if (current != null) {
            if (current.render(event)) {
                current = null;
            }
        } else if (!Temp.map.isEmpty()) {
            current = Temp.map.values().iterator().next();
            Temp.map.remove(current.getID());
        }
    }

    public static void add(Notification n) {
        if (n != null) {
            Temp.map.remove(n.getID());
            Perm.map.remove(n.getID());
            if (current != null && current.getID().equals(n.getID())) {
                current = null;
            }
            Temp.map.put(n.getID(), new Temp(n));
            if (!n.isTemp()) {
                Perm.map.put(n.getID(), new Perm(n));
            }
        }
    }

    public static void init() {
        current = null;
        Perm.map.clear();
        Temp.map.clear();
    }

    public static class Perm
    extends FinalIDObject
    implements Comparable<Perm> {
        public static final LinkedHashMap<String, Perm> map = new LinkedHashMap();
        public final Notification notification;
        public final long timeAdded;

        private Perm(Notification n) {
            super(n.getID());
            this.notification = n;
            this.timeAdded = System.currentTimeMillis();
        }

        @Override
        public int compareTo(@Nonnull Perm o) {
            return Long.compare(o.timeAdded, this.timeAdded);
        }

        public void onClicked(MouseButton button) {
            if (this.notification.getClickAction() != null) {
                this.notification.getClickAction().onClicked(button);
            }
        }
    }

    public static class Temp
    extends FinalIDObject {
        public static final LinkedHashMap<String, Temp> map = new LinkedHashMap();
        private long time;
        private NotificationWidget widget;

        private Temp(Notification n) {
            super(n.getID());
            this.widget = new NotificationWidget(n);
            this.widget.width = 0.0;
            this.time = -1L;
        }

        public boolean render(RenderGameOverlayEvent event) {
            if (this.time == -1L) {
                this.time = System.currentTimeMillis();
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (this.widget.width == 0.0) {
                for (String s : this.widget.text) {
                    this.widget.width = Math.max(this.widget.width, (double)mc.field_71466_p.func_78256_a(s));
                }
                this.widget.width += 20.0;
                if (this.widget.notification.hasItem()) {
                    this.widget.width += 20.0;
                }
            }
            if (this.time > 0L) {
                int timer;
                int timeExisted = (int)(System.currentTimeMillis() - this.time);
                if (timeExisted > (timer = this.widget.notification.getTimer())) {
                    this.time = 0L;
                    return true;
                }
                double d1 = 1.0;
                if (timer - timeExisted < 300) {
                    d1 = (double)(timer - timeExisted) / 300.0;
                }
                if (timeExisted < 300) {
                    d1 = (double)timeExisted / 300.0;
                }
                GlStateManager.func_179097_i();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                this.widget.render(mc, (double)event.getResolution().func_78326_a() - this.widget.width - 4.0, d1 * this.widget.height - this.widget.height);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179145_e();
            }
            return this.time == 0L;
        }
    }

    public static class NotificationWidget {
        public final Notification notification;
        public final List<String> text;
        public final double height;
        public double width;

        public NotificationWidget(Notification n) {
            this.notification = n;
            this.text = new ArrayList<String>();
            this.width = 0.0;
            for (ITextComponent t : this.notification.text) {
                String s = t.func_150254_d();
                this.text.add(s);
            }
            this.height = this.notification.text.size() > 2 ? (double)(4 + this.notification.text.size() * 12) : 32.0;
        }

        public void render(Minecraft mc, double ax, double ay) {
            GlStateManager.func_179147_l();
            FTBLibClient.setGLColor(this.notification.getColor(), 255);
            GuiLM.drawBlankRect(ax, ay, this.width, this.height);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.notification.hasItem()) {
                GuiLM.renderGuiItem(mc.func_175599_af(), this.notification.getItem(), ax + 8.0, ay + (this.height - 16.0) / 2.0);
            }
            for (int i = 0; i < this.text.size(); ++i) {
                mc.field_71466_p.func_78276_b(this.text.get(i), (int)ax + (this.notification.hasItem() ? 30 : 10), (int)(ay + (double)i * 11.0 + (this.height - (double)this.text.size() * 10.0) / 2.0), -1);
            }
        }
    }
}

