/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.notification;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.notification.ClickAction;
import com.feed_the_beast.ftbl.net.MessageNotifyPlayer;
import com.feed_the_beast.ftbl.util.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.FinalIDObject;
import com.latmod.lib.util.LMColorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public final class Notification
extends FinalIDObject
implements IJsonSerializable {
    public final List<ITextComponent> text = new ArrayList<ITextComponent>();
    private ItemStack item;
    private ClickAction clickAction;
    private int timer;
    private int color;

    public Notification(@Nonnull String s) {
        super(s);
    }

    public static Notification error(@Nonnull String id, @Nonnull ITextComponent title) {
        title.func_150256_b().func_150238_a(TextFormatting.WHITE);
        return new Notification(id).addText(title).setTimer(3000).setColor(0xFF5959).setItem(new ItemStack(Blocks.field_180401_cv));
    }

    public static Notification deserialize(JsonElement e) {
        JsonObject o;
        if (e != null && e.isJsonObject() && (o = e.getAsJsonObject()).has("id")) {
            Notification n = new Notification(o.get("id").getAsString());
            n.func_152753_a((JsonElement)o);
            return n;
        }
        return null;
    }

    private void setDefaults() {
        this.text.clear();
        this.timer = 3000;
        this.color = 0xA0A0A0;
        this.item = null;
        this.clickAction = null;
    }

    public Notification addText(ITextComponent t) {
        this.text.add(t);
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Notification setItem(ItemStack is) {
        this.item = is;
        return this;
    }

    public boolean hasItem() {
        return this.item != null;
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    public Notification setClickAction(ClickAction e) {
        this.clickAction = e;
        return this;
    }

    public boolean isTemp() {
        return this.clickAction == null;
    }

    public int getTimer() {
        return this.timer;
    }

    public Notification setTimer(int t) {
        this.timer = t;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public Notification setColor(int c) {
        this.color = 0xFFFFFF & c;
        return this;
    }

    @Nonnull
    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive(this.getID()));
        JsonArray a = new JsonArray();
        for (ITextComponent t : this.text) {
            a.add(JsonHelper.serializeICC(t));
        }
        o.add("text", (JsonElement)a);
        if (this.timer != 3000) {
            o.add("timer", (JsonElement)new JsonPrimitive((Number)this.timer));
        }
        if (this.item != null) {
            o.add("item", (JsonElement)new JsonPrimitive(this.item.func_77973_b().getRegistryName().toString() + ' ' + this.item.field_77994_a + ' ' + this.item.func_77960_j()));
        }
        if (this.color != 0xA0A0A0) {
            o.add("color", LMColorUtils.serialize(this.color));
        }
        if (this.clickAction != null) {
            o.add("click", this.clickAction.func_151003_a());
        }
        return o;
    }

    public void func_152753_a(@Nonnull JsonElement e) {
        if (e.isJsonObject()) {
            Item item;
            String[] s;
            this.setDefaults();
            JsonObject o = e.getAsJsonObject();
            if (o.has("text")) {
                for (JsonElement e1 : o.get("text").getAsJsonArray()) {
                    this.text.add(JsonHelper.deserializeICC(e1));
                }
            }
            int n = this.timer = o.has("timer") ? o.get("timer").getAsInt() : 3000;
            if (o.has("color")) {
                this.setColor(LMColorUtils.deserialize(o.get("color")));
            }
            if (o.has("item") && o.get("item").isJsonPrimitive() && (s = o.get("item").getAsString().split(" ")).length > 0 && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s[0]))) != null) {
                int size = 1;
                int dmg = 0;
                if (s.length > 1) {
                    size = Integer.parseInt(s[1]);
                }
                if (s.length > 2) {
                    dmg = Integer.parseInt(s[2]);
                }
                this.setItem(new ItemStack(item, size, dmg));
            }
            if (o.has("click")) {
                this.clickAction = new ClickAction();
                this.clickAction.func_152753_a(o.get("click"));
            }
        }
    }

    @Override
    @Nonnull
    public String toString() {
        return this.func_151003_a().toString();
    }

    public void sendTo(@Nullable EntityPlayerMP ep) {
        if (ep == null) {
            if (FTBLib.hasOnlinePlayers()) {
                for (EntityPlayerMP ep1 : FTBLib.getServer().func_184103_al().func_181057_v()) {
                    this.sendTo(ep1);
                }
            }
        } else {
            EnumNotificationDisplay e;
            ForgePlayerMP p = ForgeWorldMP.inst.getPlayer(ep);
            if (p != null && (e = p.notifications.get()) != EnumNotificationDisplay.OFF) {
                new MessageNotifyPlayer(this, e).sendTo(ep);
            }
        }
    }
}

