/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.paint;

import com.feed_the_beast.ftbl.api.FTBLibCapabilities;
import com.feed_the_beast.ftbl.api.LangKey;
import com.feed_the_beast.ftbl.api.paint.ICustomPaintBlock;
import com.feed_the_beast.ftbl.api.paint.IPaintable;
import com.feed_the_beast.ftbl.api.paint.IPainterItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;

public class PaintHelper {
    public static final LangKey texture_set = new LangKey("ftbl.paint.texture_set");
    public static final LangKey texture_cleared = new LangKey("ftbl.paint.texture_cleared");

    public static IBlockState getPaintFromBlock(IBlockAccess w, IBlockState state, RayTraceResult hit) {
        if (state.func_177230_c() instanceof ICustomPaintBlock) {
            return ((ICustomPaintBlock)state.func_177230_c()).getCustomPaint(w, state, hit);
        }
        return !state.func_177230_c().hasTileEntity(state) && state.func_185917_h() ? state : null;
    }

    public static ActionResult<ItemStack> onItemRightClick(ItemStack is, EntityPlayer ep) {
        IPainterItem painterItem;
        if (!ep.field_70170_p.field_72995_K && ep.func_70093_af() && is.hasCapability(FTBLibCapabilities.PAINTER_ITEM, null) && (painterItem = (IPainterItem)is.getCapability(FTBLibCapabilities.PAINTER_ITEM, null)).getPaint() != null) {
            painterItem.setPaint(null);
            texture_cleared.printChat((ICommandSender)ep, new Object[0]);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)is);
    }

    public static EnumActionResult onItemUse(ItemStack is, EntityPlayer ep, RayTraceResult hit) {
        IBlockState blockPaint;
        IBlockState state;
        if (ep.field_70170_p.field_72995_K || !is.hasCapability(FTBLibCapabilities.PAINTER_ITEM, null)) {
            return EnumActionResult.SUCCESS;
        }
        IPainterItem painterItem = (IPainterItem)is.getCapability(FTBLibCapabilities.PAINTER_ITEM, null);
        TileEntity te = ep.field_70170_p.func_175625_s(hit.func_178782_a());
        if (te != null) {
            IBlockState paint = painterItem.getPaint();
            if (ep.func_70093_af()) {
                if (painterItem.canPaintBlocks(is)) {
                    boolean b = false;
                    for (EnumFacing f : EnumFacing.field_82609_l) {
                        IPaintable paintable;
                        if (!te.hasCapability(FTBLibCapabilities.PAINTABLE_TILE, f) || !(paintable = (IPaintable)te.getCapability(FTBLibCapabilities.PAINTABLE_TILE, f)).canSetPaint(ep, paint)) continue;
                        paintable.setPaint(paint);
                        b = true;
                    }
                    if (b) {
                        painterItem.damagePainter(is, ep);
                        te.func_70296_d();
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            if (painterItem.canPaintBlocks(is) && te.hasCapability(FTBLibCapabilities.PAINTABLE_TILE, hit.field_178784_b)) {
                IPaintable paintable = (IPaintable)te.getCapability(FTBLibCapabilities.PAINTABLE_TILE, hit.field_178784_b);
                if (paintable.canSetPaint(ep, paint)) {
                    paintable.setPaint(paint);
                    painterItem.damagePainter(is, ep);
                    te.func_70296_d();
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (ep.func_70093_af() && !ep.field_70170_p.func_175623_d(hit.func_178782_a()) && (state = ep.field_70170_p.func_180495_p(hit.func_178782_a())).func_185917_h() && (blockPaint = PaintHelper.getPaintFromBlock((IBlockAccess)ep.field_70170_p, state, hit)) != painterItem.getPaint()) {
            painterItem.setPaint(blockPaint);
            texture_set.printChat((ICommandSender)ep, new ItemStack(blockPaint.func_177230_c(), 1, blockPaint.func_177230_c().func_176201_c(blockPaint)).func_82833_r());
        }
        return EnumActionResult.SUCCESS;
    }
}

