/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.permissions;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.permissions.Context;
import com.feed_the_beast.ftbl.api.permissions.PermissionHandler;
import com.mojang.authlib.GameProfile;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

@ParametersAreNonnullByDefault
public class PermissionAPI {
    private static PermissionHandler permissionHandler;

    public static void setPermissionHandler(PermissionHandler handler) {
        if (permissionHandler != null) {
            FTBLibMod.logger.warn("Replacing " + permissionHandler.getClass().getName() + " with " + handler.getClass().getName());
        }
        permissionHandler = handler;
    }

    public static boolean hasPermission(GameProfile profile, String permission, boolean defaultForPlayer, Context context) {
        if (permission.isEmpty()) {
            throw new NullPointerException("Permission string can't be empty!");
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return true;
        }
        if (!server.func_71262_S() || server.func_184103_al().func_152603_m().func_187452_a(profile) > 0) {
            return true;
        }
        if (permissionHandler == null) {
            return defaultForPlayer;
        }
        switch (permissionHandler.hasPermission(profile, permission, context)) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return defaultForPlayer;
    }
}

