/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.permissions.rankconfig;

import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfigAPI;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.google.gson.JsonElement;
import com.latmod.lib.FinalIDObject;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;

public class RankConfig
extends FinalIDObject {
    private JsonElement defaultPlayerValue;
    private JsonElement defaultOPValue;

    public RankConfig(String id, @Nonnull JsonElement player, @Nonnull JsonElement op) {
        super(id);
        this.setDefaultValue(false, player);
        this.setDefaultValue(true, op);
    }

    public final void setDefaultValue(boolean op, @Nonnull JsonElement value) {
        if (op) {
            this.defaultOPValue = value;
        } else {
            this.defaultPlayerValue = value;
        }
    }

    public final JsonElement getDefaultValue(boolean op) {
        return op ? this.defaultOPValue : this.defaultPlayerValue;
    }

    public JsonElement getJson(@Nonnull GameProfile profile) {
        if (RankConfigAPI.rankConfigHandler != null) {
            return RankConfigAPI.rankConfigHandler.getRankConfig(profile, this);
        }
        return this.getDefaultValue(FTBLib.isOP(profile));
    }

    public ConfigEntryType getType() {
        return ConfigEntryType.CUSTOM;
    }
}

