/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.permissions.rankconfig;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfig;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RankConfigAPI {
    private static final Map<String, RankConfig> map = new HashMap<String, RankConfig>();
    static Handler rankConfigHandler;

    public static void setHandler(@Nonnull Handler handler) {
        if (rankConfigHandler != null) {
            FTBLibMod.logger.warn("Replacing " + rankConfigHandler.getClass().getName() + " with " + handler.getClass().getName());
        }
        rankConfigHandler = handler;
    }

    public static <E extends RankConfig> E register(@Nonnull E rankConfig) {
        if (map.containsKey(rankConfig.getID())) {
            throw new RuntimeException("Duplicate RankConfig ID found: " + rankConfig.getID());
        }
        map.put(rankConfig.getID(), rankConfig);
        return rankConfig;
    }

    public static void registerAll(Class<?> c) {
        try {
            for (Field f : c.getDeclaredFields()) {
                if (!RankConfig.class.isAssignableFrom(f.getType())) continue;
                RankConfigAPI.register((RankConfig)f.get(null));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Collection<RankConfig> getRankConfigValues() {
        return map.values();
    }

    public static RankConfig getRankConfig(String s) {
        return map.get(s);
    }

    public static interface Handler {
        public JsonElement getRankConfig(@Nonnull GameProfile var1, @Nonnull RankConfig var2);
    }
}

