/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.recipes;

import com.feed_the_beast.ftbl.api.item.LMInvUtils;
import com.feed_the_beast.ftbl.api.item.MaterialItem;
import com.feed_the_beast.ftbl.api.item.ODItems;
import com.feed_the_beast.ftbl.api.recipes.IStackArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class StackArray
implements IStackArray {
    public final Collection<ItemStack> items;
    private int hashCode;
    private IStackArray[] array;

    public StackArray(Object o) {
        this.items = StackArray.getItems(o);
        this.hashCode = this.toString().hashCode();
        this.array = new IStackArray[]{this};
    }

    public static StackArray[] convert(ItemStack ... o) {
        if (o == null) {
            return null;
        }
        StackArray[] se = new StackArray[o.length];
        for (int i = 0; i < o.length; ++i) {
            se[i] = o[i] == null ? null : new StackArray(o[i]);
        }
        return se;
    }

    public static StackArray[] convert(Object ... o) {
        if (o == null) {
            return null;
        }
        StackArray[] se = new StackArray[o.length];
        for (int i = 0; i < o.length; ++i) {
            se[i] = o[i] == null ? null : new StackArray(o[i]);
        }
        return se;
    }

    public static StackArray[] convertInv(IInventory inv, EnumFacing side) {
        if (inv == null) {
            return null;
        }
        return StackArray.convert(LMInvUtils.getAllItems(inv, side));
    }

    public static Collection<ItemStack> getItems(Object o) {
        if (o == null) {
            return new ArrayList<ItemStack>();
        }
        ItemStack item0 = StackArray.getFrom(o);
        if (item0 != null) {
            return Collections.singleton(item0);
        }
        if (o instanceof ItemStack[]) {
            return Arrays.asList((ItemStack[])o);
        }
        if (o instanceof String) {
            ODItems.getOres((String)o);
        }
        return new ArrayList<ItemStack>();
    }

    public static ItemStack getFrom(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        if (o instanceof MaterialItem) {
            return ((MaterialItem)o).getStack(1);
        }
        return null;
    }

    public static boolean itemsEquals(ItemStack is1, ItemStack is2) {
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return false;
        }
        if (is1.func_77973_b() == is2.func_77973_b()) {
            int dmg2;
            int dmg1 = is1.func_77952_i();
            return dmg1 == (dmg2 = is1.func_77952_i()) || dmg2 == Short.MAX_VALUE;
        }
        return false;
    }

    public String toString() {
        return "StackEntry: " + this.items;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Collection<ItemStack> items1 = o instanceof StackArray ? ((StackArray)o).items : StackArray.getItems(o);
        if (items1 != null) {
            for (ItemStack is1 : items1) {
                if (!this.equalsItem(is1)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalsItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        for (ItemStack is1 : this.items) {
            if (!StackArray.itemsEquals(is, is1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ItemStack[] ai) {
        return ai != null && ai.length == 1 && this.equalsItem(ai[0]);
    }

    @Override
    public IStackArray[] getItems() {
        return this.array;
    }
}

