/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.security;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.LangKey;
import com.feed_the_beast.ftbl.api.client.gui.GuiIcons;
import com.feed_the_beast.ftbl.api.config.EnumNameMap;
import com.feed_the_beast.ftbl.util.TextureCoords;

public enum EnumPrivacyLevel {
    PUBLIC,
    PRIVATE,
    TEAM;

    public static final EnumPrivacyLevel[] VALUES;
    public static final LangKey enumLangKey;
    public static final EnumNameMap<EnumPrivacyLevel> NAME_MAP;
    public final LangKey langKey = new LangKey("ftbl.privacy." + this.name().toLowerCase());

    public static EnumPrivacyLevel get(String s) {
        if (s == null || s.isEmpty()) {
            return PUBLIC;
        }
        if (s.equalsIgnoreCase("team")) {
            return TEAM;
        }
        if (s.equalsIgnoreCase("private")) {
            return PRIVATE;
        }
        return PUBLIC;
    }

    public TextureCoords getIcon() {
        return GuiIcons.security[this.ordinal()];
    }

    public boolean isPublic() {
        return this == PUBLIC;
    }

    public boolean canInteract(ForgePlayer owner, ForgePlayer player) {
        if (this == PUBLIC || owner == null) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (owner.equalsPlayer(player)) {
            return true;
        }
        if (this == PRIVATE) {
            return false;
        }
        return this == TEAM && owner.hasTeam() && owner.getTeam().getStatus(player).isAlly();
    }

    static {
        VALUES = EnumPrivacyLevel.values();
        enumLangKey = new LangKey("ftbl.privacy");
        NAME_MAP = new EnumNameMap(false, (Enum[])VALUES);
    }
}

