/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.security;

import com.feed_the_beast.ftbl.api.config.EnumNameMap;
import com.feed_the_beast.ftbl.api.security.EnumPrivacyLevel;
import com.feed_the_beast.ftbl.api.security.ISecure;
import com.feed_the_beast.ftbl.api.security.ISecureModifiable;
import com.latmod.lib.util.LMUtils;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public enum ISecureStorage implements Capability.IStorage<ISecure>
{
    INSTANCE;


    public NBTBase writeNBT(Capability<ISecure> capability, ISecure instance, EnumFacing side) {
        boolean saveOwner = instance.saveOwner();
        boolean saveLevel = instance.savePrivacyLevel();
        UUID ownerID = instance.getOwner();
        if (saveOwner && !saveLevel) {
            return new NBTTagString(ownerID == null ? "" : LMUtils.fromUUID(ownerID));
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (saveOwner && ownerID != null) {
            tag.func_74778_a("Owner", LMUtils.fromUUID(ownerID));
        }
        if (saveLevel) {
            tag.func_74778_a("Level", EnumNameMap.getEnumName(instance.getPrivacyLevel()));
        }
        return tag;
    }

    public void readNBT(Capability<ISecure> capability, ISecure instance, EnumFacing side, NBTBase nbt) {
        if (!(instance instanceof ISecureModifiable)) {
            throw new RuntimeException("ISecure instance does not implement ISecureModifiable");
        }
        ISecureModifiable sm = (ISecureModifiable)instance;
        if (nbt instanceof NBTTagString) {
            sm.setOwner(instance.saveOwner() ? LMUtils.fromString(((NBTTagString)nbt).func_150285_a_()) : null);
        } else {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            sm.setOwner(tag.func_74764_b("Owner") ? LMUtils.fromString(tag.func_74779_i("Owner")) : null);
            sm.setPrivacyLevel(instance.savePrivacyLevel() && tag.func_74764_b("Level") ? EnumPrivacyLevel.NAME_MAP.get(tag.func_74779_i("Level")) : EnumPrivacyLevel.PUBLIC);
        }
    }
}

