/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.security;

import com.feed_the_beast.ftbl.api.FTBLibCapabilities;
import com.feed_the_beast.ftbl.api.security.EnumPrivacyLevel;
import com.feed_the_beast.ftbl.api.security.ISecureModifiable;
import com.feed_the_beast.ftbl.api.security.ISecureStorage;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.util.INBTSerializable;

public class Security
implements ISecureModifiable,
INBTSerializable<NBTBase> {
    private final boolean saveOwner;
    private final boolean savePrivacyLevel;
    private UUID owner;
    private EnumPrivacyLevel level = EnumPrivacyLevel.PUBLIC;

    public Security(boolean sOwner, boolean sPrivacyLevel) {
        this.saveOwner = sOwner;
        this.savePrivacyLevel = sPrivacyLevel;
    }

    @Override
    public boolean saveOwner() {
        return this.saveOwner;
    }

    @Override
    public boolean savePrivacyLevel() {
        return this.savePrivacyLevel;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable UUID id) {
        this.owner = id;
    }

    public final boolean hasOwner() {
        return this.getOwner() != null;
    }

    @Override
    @Nonnull
    public EnumPrivacyLevel getPrivacyLevel() {
        return this.level;
    }

    @Override
    public void setPrivacyLevel(@Nonnull EnumPrivacyLevel l) {
        this.level = l;
    }

    public NBTBase serializeNBT() {
        return ISecureStorage.INSTANCE.writeNBT(FTBLibCapabilities.SECURE, this, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        ISecureStorage.INSTANCE.readNBT(FTBLibCapabilities.SECURE, this, null, nbt);
    }
}

