/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.tile;

import com.feed_the_beast.ftbl.api.item.LMInvUtils;
import com.feed_the_beast.ftbl.api.tile.TileLM;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileInvLM
extends TileLM {
    public ItemStackHandler itemHandler;
    public boolean dropItems = true;

    public TileInvLM(int size) {
        this.itemHandler = this.createHandler(size);
    }

    protected ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileInvLM.this.func_70296_d();
            }
        };
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readTileData(@Nonnull NBTTagCompound tag) {
        super.readTileData(tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public void writeTileData(@Nonnull NBTTagCompound tag) {
        super.writeTileData(tag);
        tag.func_74782_a("Items", (NBTBase)this.itemHandler.serializeNBT());
    }

    @Override
    public void onBroken(@Nonnull IBlockState state) {
        if (this.dropItems && this.getSide().isServer() && this.itemHandler != null && this.itemHandler.getSlots() > 0) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack item = this.itemHandler.getStackInSlot(i);
                if (item == null || item.field_77994_a <= 0) continue;
                LMInvUtils.dropItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, item, 10);
            }
        }
        this.func_70296_d();
        super.onBroken(state);
    }
}

