/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.tile;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.security.Security;
import com.feed_the_beast.ftbl.api.tile.IEditableName;
import com.feed_the_beast.ftbl.api.tile.TileClientAction;
import com.feed_the_beast.ftbl.api.tile.TileClientActionRegistry;
import com.feed_the_beast.ftbl.net.MessageClientTileAction;
import com.feed_the_beast.ftbl.util.BlockDimPos;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

@ParametersAreNonnullByDefault
public class TileLM
extends TileEntity
implements IEditableName {
    public final Security security = this.createSecurity();
    public boolean isLoaded = false;
    public boolean redstonePowered = false;
    private boolean isDirty = true;
    private IBlockState currentState;

    protected Security createSecurity() {
        return new Security(true, false);
    }

    @Nonnull
    public final NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeTileData(tag);
        tag.func_74782_a("Security", this.security.serializeNBT());
        return tag;
    }

    public final void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.security.deserializeNBT(tag.func_74781_a("Security"));
        this.readTileData(tag);
    }

    @Nullable
    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Security", this.security.serializeNBT());
        this.writeTileClientData(tag);
        return tag;
    }

    public final void onDataPacket(NetworkManager m, SPacketUpdateTileEntity p) {
        NBTTagCompound tag = p.func_148857_g();
        this.security.deserializeNBT(tag.func_74781_a("Security"));
        this.readTileClientData(tag);
        this.onUpdatePacket();
        FTBLibClient.onGuiClientAction();
    }

    public void writeTileData(NBTTagCompound tag) {
    }

    public void readTileData(NBTTagCompound tag) {
    }

    public void writeTileClientData(NBTTagCompound tag) {
        this.writeTileData(tag);
    }

    public void readTileClientData(NBTTagCompound tag) {
        this.readTileData(tag);
    }

    public EnumSync getSync() {
        return EnumSync.SYNC;
    }

    public void onUpdatePacket() {
        if (this.getSync().rerender()) {
            IBlockState state = this.getBlockState();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean onRightClick(@Nonnull EntityPlayer ep, @Nullable ItemStack is, @Nonnull EnumFacing side, @Nonnull EnumHand hand, float x, float y, float z) {
        return false;
    }

    public void onLoad() {
        this.isLoaded = true;
    }

    public void onChunkUnload() {
        this.isLoaded = false;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public final void checkIfDirty() {
        if (this.isDirty) {
            this.sendDirtyUpdate();
            this.isDirty = false;
        }
    }

    public void sendDirtyUpdate() {
        if (this.field_145850_b != null) {
            this.func_145836_u();
            if (this.getSync().sync()) {
                IBlockState state = this.getBlockState();
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.currentState = null;
    }

    public IBlockState getBlockState() {
        if (this.currentState == null) {
            this.currentState = this.field_145850_b.func_180495_p(this.func_174877_v());
        }
        return this.currentState;
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is, IBlockState state) {
        this.security.setOwner(ep.func_146103_bH().getId());
        if (is.func_82837_s()) {
            this.setName(is.func_82833_r());
        }
        this.func_70296_d();
    }

    public void onBroken(@Nonnull IBlockState state) {
    }

    public boolean isExplosionResistant() {
        return !this.security.getPrivacyLevel().isPublic();
    }

    public final void sendClientAction(TileClientAction action, NBTTagCompound data) {
        new MessageClientTileAction(this, action, data).sendToServer();
    }

    public void clientPressButton(int button, MouseButton mouseButton, NBTTagCompound data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("I", button);
        tag.func_74774_a("MB", (byte)mouseButton.ordinal());
        if (data != null && !data.func_82582_d()) {
            tag.func_74782_a("D", (NBTBase)data);
        }
        this.sendClientAction(TileClientActionRegistry.BUTTON_PRESSED, tag);
    }

    public void clientCustomName(String name) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("N", name);
        this.sendClientAction(TileClientActionRegistry.CUSTOM_NAME, data);
    }

    public final Side getSide() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K ? Side.SERVER : Side.CLIENT;
    }

    public void notifyNeighbors() {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.func_145838_q());
    }

    public void onNeighborBlockChange(BlockPos pos) {
        if (this.field_145850_b != null) {
            this.redstonePowered = this.field_145850_b.func_175640_z(this.func_174877_v());
            this.func_145836_u();
        }
    }

    @Override
    public boolean canSetName(ICommandSender ics) {
        return true;
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    @Override
    public void setName(String s) {
    }

    public boolean func_145818_k_() {
        return !this.func_70005_c_().isEmpty();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_145838_q().func_149732_F() + ".name", new Object[0]);
    }

    public void playSound(SoundEvent event, SoundCategory category, float volume, float pitch) {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, event, category, volume, pitch);
    }

    public BlockDimPos getDimPos() {
        return new BlockDimPos((Vec3i)this.field_174879_c, this.func_145830_o() ? this.field_145850_b.field_73011_w.getDimension() : 0);
    }

    protected static enum EnumSync {
        OFF,
        SYNC,
        RERENDER;


        boolean sync() {
            return this == SYNC || this == RERENDER;
        }

        boolean rerender() {
            return this == RERENDER;
        }
    }
}

