/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.client.LMFrustumUtils;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.guibuttons.ActionButton;
import com.feed_the_beast.ftbl.api.client.gui.guibuttons.ActionButtonRegistry;
import com.feed_the_beast.ftbl.api.item.ODItems;
import com.feed_the_beast.ftbl.api.notification.ClientNotifications;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.util.FTBLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FTBLibClientEventHandler {
    public static final FTBLibClientEventHandler instance = new FTBLibClientEventHandler();

    @SubscribeEvent
    public void onDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (ForgeWorldSP.inst != null) {
            ForgeWorldSP.inst.onClosed();
            ForgeWorldSP.inst = null;
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Collection<String> ores;
        if (FTBLibModClient.item_ore_names.getAsBoolean() && !(ores = ODItems.getOreNames(event.getItemStack())).isEmpty()) {
            event.getToolTip().add("Ore Dictionary names:");
            for (String or : ores) {
                event.getToolTip().add("> " + or);
            }
        }
    }

    @SubscribeEvent
    public void onDrawDebugText(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P && FTBLib.DEV_ENV) {
            event.getLeft().add("[MC " + TextFormatting.GOLD + "1.9.4" + TextFormatting.WHITE + " DevEnv]");
        }
    }

    @SubscribeEvent
    public void guiInitEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        block9: {
            List<ActionButton> buttons;
            if (ForgeWorldSP.inst == null || !(event.getGui() instanceof InventoryEffectRenderer) || (buttons = ActionButtonRegistry.getButtons(ForgeWorldSP.inst.clientPlayer, false, false)).isEmpty()) break block9;
            Collections.sort(buttons);
            ButtonInvLMRenderer renderer = new ButtonInvLMRenderer(495830, event.getGui());
            event.getButtonList().add(renderer);
            if (FTBLibModClient.action_buttons_on_top.getAsBoolean()) {
                for (int i = 0; i < buttons.size(); ++i) {
                    ActionButton a = buttons.get(i);
                    int x = i % 4;
                    int y = i / 4;
                    ButtonInvLM b = new ButtonInvLM(495830 + i, a, 4 + x * 18, 4 + y * 18);
                    event.getButtonList().add(b);
                    renderer.buttons.add(b);
                }
            } else {
                boolean hasPotions;
                int xSize = 176;
                int ySize = 166;
                int buttonX = -17;
                int buttonY = 8;
                if (event.getGui() instanceof GuiContainerCreative) {
                    xSize = 195;
                    ySize = 136;
                    buttonY = 6;
                }
                boolean bl = hasPotions = !event.getGui().field_146297_k.field_71439_g.func_70651_bq().isEmpty();
                if (hasPotions) {
                    buttonX -= 4;
                    buttonY -= 26;
                }
                int guiLeft = (event.getGui().field_146294_l - xSize) / 2;
                int guiTop = (event.getGui().field_146295_m - ySize) / 2;
                if (hasPotions) {
                    guiLeft += 60;
                }
                for (int i = 0; i < buttons.size(); ++i) {
                    ButtonInvLM b;
                    int y;
                    int x;
                    ActionButton a = buttons.get(i);
                    if (hasPotions) {
                        x = i % 8;
                        y = i / 8;
                        b = new ButtonInvLM(495830 + i, a, guiLeft + buttonX - 18 * x, guiTop + buttonY - y * 18);
                    } else {
                        x = i / 8;
                        y = i % 8;
                        b = new ButtonInvLM(495830 + i, a, guiLeft + buttonX - 18 * x, guiTop + buttonY + 18 * y);
                    }
                    event.getButtonList().add(b);
                    renderer.buttons.add(b);
                }
            }
        }
    }

    @SubscribeEvent
    public void guiActionEvent(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof ButtonInvLM) {
            ActionButton b = ((ButtonInvLM)event.getButton()).button;
            b.onClicked(ForgeWorldSP.inst.clientPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderGui(RenderGameOverlayEvent event) {
        GlStateManager.func_179094_E();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ClientNotifications.renderTemp(event);
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent e) {
        LMFrustumUtils.update();
    }

    private static class ButtonInvLMRenderer
    extends GuiButton {
        public final List<ButtonInvLM> buttons = new ArrayList<ButtonInvLM>();

        public ButtonInvLMRenderer(int id, GuiScreen g) {
            super(id, -1000, -1000, 0, 0, "");
        }

        public void func_146112_a(@Nonnull Minecraft mc, int mx, int my) {
            this.field_73735_i = 0.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (ButtonInvLM b : this.buttons) {
                b.button.render(mc, b.field_146128_h, b.field_146129_i);
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                GuiLM.drawBlankRect(b.field_146128_h, b.field_146129_i, b.field_146120_f, b.field_146121_g);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            for (ButtonInvLM b : this.buttons) {
                b.button.postRender(mc, b.field_146128_h, b.field_146129_i);
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                GlStateManager.func_179094_E();
                double mx1 = (double)mx - 4.0;
                double my1 = (double)my - 12.0;
                String s = b.button.displayName.func_150254_d();
                int tw = mc.field_71466_p.func_78256_a(s);
                if (!FTBLibModClient.action_buttons_on_top.getAsBoolean()) {
                    mx1 -= (double)(tw + 8);
                    my1 += 4.0;
                }
                if (mx1 < 4.0) {
                    mx1 = 4.0;
                }
                if (my1 < 4.0) {
                    my1 = 4.0;
                }
                GlStateManager.func_179137_b((double)mx1, (double)my1, (double)this.field_73735_i);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)0.13f, (float)0.13f, (float)0.13f, (float)1.0f);
                GuiLM.drawBlankRect(-3.0, -2.0, tw + 6, 12.0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71466_p.func_78276_b(s, 0, 0, -1);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static class ButtonInvLM
    extends GuiButton {
        public final ActionButton button;

        public ButtonInvLM(int id, ActionButton b, int x, int y) {
            super(id, x, y, 16, 16, "");
            this.button = b;
        }

        public void func_146112_a(@Nonnull Minecraft mc, int mx, int my) {
        }
    }
}

