/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.cmd.team;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.cmd.CommandLM;
import com.feed_the_beast.ftbl.api.events.ForgeTeamEvent;
import com.feed_the_beast.ftbl.net.MessageUpdateTeam;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CmdCreate
extends CommandLM {
    public CmdCreate() {
        super("create");
    }

    private static boolean isValidTeamID(String s) {
        if (s != null && !s.isEmpty()) {
            for (int i = 0; i < s.length(); ++i) {
                if (CmdCreate.isValidChar(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValidChar(char c) {
        return c == '_' || c == '|' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        EntityPlayerMP ep = CmdCreate.func_71521_c((ICommandSender)sender);
        ForgePlayerMP p = ForgePlayerMP.get(ep);
        if (p.hasTeam()) {
            throw FTBLibLang.team_must_leave.commandError(new Object[0]);
        }
        CmdCreate.checkArgs(args, 1, "<ID>");
        if (!CmdCreate.isValidTeamID(args[0])) {
            throw FTBLibLang.raw.commandError("ID can only contain lowercase a-z, _ and |!");
        }
        if (ForgeWorldMP.inst.teams.containsKey(args[0])) {
            throw FTBLibLang.raw.commandError("ID already registred!");
        }
        ForgeTeam team = new ForgeTeam(ForgeWorldMP.inst, args[0]);
        team.changeOwner(p);
        ForgeWorldMP.inst.teams.put(team.getID(), team);
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.Created(team));
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamEvent.PlayerJoined(team, p));
        new MessageUpdateTeam(p, team).sendTo(null);
        FTBLibLang.team_created.printChat(sender, team.getID());
    }
}

